/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerBurrowDownGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerLookAroundGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerLookAtEntityGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerMeeleAttackGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerWanderAroundFarGoal;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.animation.MaulerAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityDataSerializers;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedInteractionResult;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class MaulerEntity
extends Animal
implements NeutralMob,
AnimatedEntity {
    private static final int HEALTH = 20;
    private static final float ANGERED_MOVEMENT_SPEED = 0.5f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float ATTACK_DAMAGE = 8.0f;
    private static final int MAXIMUM_STORED_EXPERIENCE_POINTS = 1395;
    public static final int MIN_TICKS_UNTIL_NEXT_BURROWING = 3000;
    public static final int MAX_TICKS_UNTIL_NEXT_BURROWING = 6000;
    private static final Type DEFAULT_TYPE = Type.DESERT;
    private static final String TYPE_NBT_NAME = "Type";
    private static final String STORED_EXPERIENCE_POINTS_NBT_NAME = "StoredExperiencePoints";
    private static final String IS_BURROWED_DOWN_NBT_NAME = "IsBurrowedDown";
    private static final String TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME = "TicksUntilNextBurrowingDown";
    private static final String BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME = "BurrowingDownAnimationProgress";
    private static final String BURROWED_DOWN_TICKS_NBT_NAME = "BurrowedDownTicks";
    private static final EntityDataAccessor<String> TYPE;
    private static final EntityDataAccessor<Integer> ANGER_TIME;
    private static final EntityDataAccessor<Integer> STORED_EXPERIENCE_POINTS;
    private static final EntityDataAccessor<Boolean> IS_MOVING;
    private static final EntityDataAccessor<Boolean> IS_BURROWED_DOWN;
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_NEXT_BURROWING_DOWN;
    private static final EntityDataAccessor<Float> BURROWING_DOWN_ANIMATION_PROGRESS;
    private static final EntityDataAccessor<Integer> POSE_TICKS;
    private static final EntityDataAccessor<FriendsAndFoesEntityPose> ENTITY_POSE;
    @Nullable
    private UUID angryAt;
    public MaulerBurrowDownGoal burrowDownGoal;
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (AnimationHolder animation : this.getTrackedAnimations()) {
                this.animationContextTracker.add(animation);
            }
            this.animationContextTracker.add(MaulerAnimations.SNAP);
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<AnimationHolder> getTrackedAnimations() {
        return MaulerAnimations.TRACKED_ANIMATIONS;
    }

    @Override
    public AnimationHolder getMovementAnimation() {
        if (this.isAngry()) {
            return MaulerAnimations.WALK;
        }
        return MaulerAnimations.RUN;
    }

    @Override
    public int getCurrentAnimationTick() {
        return (Integer)this.entityData.get(POSE_TICKS);
    }

    @Override
    public void setCurrentAnimationTick(int keyframeAnimationTicks) {
        this.entityData.set(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    @Override
    @Nullable
    public AnimationHolder getAnimationByPose() {
        AnimationHolder animation = null;
        if (this.isInEntityPose(FriendsAndFoesEntityPose.IDLE) && !this.walkAnimation.isMoving()) {
            animation = MaulerAnimations.IDLE;
        }
        return animation;
    }

    public MaulerEntity(EntityType<? extends MaulerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)DEFAULT_TYPE.name());
        builder.define(ANGER_TIME, (Object)0);
        builder.define(STORED_EXPERIENCE_POINTS, (Object)0);
        builder.define(IS_MOVING, (Object)false);
        builder.define(IS_BURROWED_DOWN, (Object)false);
        builder.define(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)this.getRandom().nextIntBetweenInclusive(3000, 6000));
        builder.define(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(POSE_TICKS, (Object)0);
        builder.define(ENTITY_POSE, (Object)FriendsAndFoesEntityPose.IDLE);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
        nbt.putString(TYPE_NBT_NAME, this.getMaulerType().getName());
        nbt.putInt(STORED_EXPERIENCE_POINTS_NBT_NAME, this.getStoredExperiencePoints());
        nbt.putBoolean(IS_BURROWED_DOWN_NBT_NAME, this.isBurrowedDown());
        nbt.putInt(TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME, this.getTicksUntilNextBurrowingDown());
        nbt.putFloat(BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME, this.getBurrowingDownAnimationProgress());
        if (this.burrowDownGoal != null && this.isBurrowedDown() && this.burrowDownGoal.getBurrowedDownTicks() > 0) {
            nbt.putInt(BURROWED_DOWN_TICKS_NBT_NAME, this.burrowDownGoal.getBurrowedDownTicks());
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        int burrowedDownTicks;
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
        this.setType(Type.fromName(VersionedNbt.getString(nbt, TYPE_NBT_NAME, this.getMaulerType().getName())));
        this.setStoredExperiencePoints(VersionedNbt.getInt(nbt, STORED_EXPERIENCE_POINTS_NBT_NAME, this.getStoredExperiencePoints()));
        this.setBurrowedDown(VersionedNbt.getBoolean(nbt, IS_BURROWED_DOWN_NBT_NAME, this.isBurrowedDown()));
        this.setTicksUntilNextBurrowingDown(VersionedNbt.getInt(nbt, TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME, this.getTicksUntilNextBurrowingDown()));
        this.setBurrowingDownAnimationProgress(VersionedNbt.getFloat(nbt, BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME, this.getBurrowingDownAnimationProgress()));
        if (this.burrowDownGoal != null && this.isBurrowedDown() && (burrowedDownTicks = VersionedNbt.getInt(nbt, BURROWED_DOWN_TICKS_NBT_NAME, 0)) != 0) {
            this.burrowDownGoal.setBurrowedDownTicks(burrowedDownTicks);
            this.setInvulnerable(true);
            this.setInvisible(true);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        ResourceKey biomeKey = world.getBiome(this.blockPosition()).unwrapKey().orElse(Biomes.SAVANNA);
        Type type = Type.getTypeByBiome((ResourceKey<Biome>)biomeKey);
        this.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        this.setType(type);
        this.setSize();
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public static boolean canSpawn(EntityType<MaulerEntity> maulerEntityType, ServerLevelAccessor serverWorldAccess, EntitySpawnReason spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.getBlockState(blockPos.below()).is(FriendsAndFoesTags.MAULERS_SPAWNABLE_ON);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MaulerMeeleAttackGoal((PathfinderMob)this, 0.5, false));
        this.goalSelector.addGoal(3, (Goal)new MaulerWanderAroundFarGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(4, (Goal)new MaulerLookAtEntityGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(5, (Goal)new MaulerLookAroundGoal(this));
        this.burrowDownGoal = new MaulerBurrowDownGoal(this);
        this.goalSelector.addGoal(6, (Goal)this.burrowDownGoal);
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 10, true, true, (livingEntity, serverLevel) -> {
            Zombie zombie;
            Slime slimeEntity;
            if (livingEntity instanceof Slime && (slimeEntity = (Slime)livingEntity).getSize() != 1 || livingEntity instanceof Zombie && !(zombie = (Zombie)livingEntity).isBaby()) {
                return false;
            }
            return livingEntity.getType().is(FriendsAndFoesTags.MAULER_PREY);
        }));
    }

    public void tick() {
        if (!FriendsAndFoes.getConfig().enableMauler) {
            this.discard();
        }
        this.setSize();
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (this.getTicksUntilNextBurrowingDown() > 0) {
            this.setTicksUntilNextBurrowingDown(this.getTicksUntilNextBurrowingDown() - 1);
        }
        this.updateBurrowingDownAnimation();
    }

    public void aiStep() {
        if (!this.level().isClientSide() && this.getBurrowingDownAnimationProgress() > 0.0f) {
            this.getNavigation().setSpeedModifier(0.0);
            this.getNavigation().stop();
        }
        super.aiStep();
        if (this.level().isClientSide()) {
            return;
        }
        this.updatePersistentAnger((ServerLevel)this.level(), true);
        this.setMoving(this.getNavigation().isInProgress());
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (!this.level().isClientSide() && this.burrowDownGoal.isRunning()) {
            this.burrowDownGoal.stop();
        }
        return super.hurtServer(level, damageSource, amount);
    }

    public float getSpeed() {
        return this.isAngry() ? 0.5f : 0.3f;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item itemInHand = itemStack.getItem();
        boolean interactionResult = false;
        if (!(this.isAngry() || itemStack.isEmpty() || !itemStack.isEnchanted() && itemInHand != Items.ENCHANTED_BOOK)) {
            interactionResult = this.tryToInteractWithEnhancedItem(player, hand, itemStack);
        } else if (!this.isAngry() && itemInHand == Items.GLASS_BOTTLE) {
            interactionResult = this.tryToInteractWithGlassBottle(player, itemStack);
        }
        if (interactionResult) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
            return VersionedInteractionResult.success((Entity)this);
        }
        return super.mobInteract(player, hand);
    }

    private boolean tryToInteractWithEnhancedItem(Player player, InteractionHand hand, ItemStack itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints >= 1395) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setPersistenceRequired();
            int experiencePoints = this.getExperiencePoints(itemStack);
            int recalculatedExperiencePoints = storedExperiencePoints + experiencePoints;
            if (recalculatedExperiencePoints > 1395) {
                recalculatedExperiencePoints = 1395;
            }
            this.setStoredExperiencePoints(recalculatedExperiencePoints);
            if (!player.getAbilities().instabuild) {
                if (itemStack.isStackable()) {
                    itemStack.shrink(1);
                } else {
                    EquipmentSlot equipmentSlot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    player.setItemSlot(equipmentSlot, ItemStack.EMPTY);
                }
            }
            this.playSound((SoundEvent)FriendsAndFoesSoundEvents.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
            this.spawnParticles((ParticleOptions)ParticleTypes.ENCHANT, 7);
        }
        return true;
    }

    private boolean tryToInteractWithGlassBottle(Player player, ItemStack itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints < 7) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setPersistenceRequired();
            int glassBottlesCount = itemStack.getCount();
            int experienceBottleCount = storedExperiencePoints / 7;
            if (experienceBottleCount > glassBottlesCount) {
                experienceBottleCount = glassBottlesCount;
            }
            itemStack.shrink(experienceBottleCount);
            ItemStack experienceBottleItemStack = new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, experienceBottleCount);
            player.addItem(experienceBottleItemStack);
            this.setStoredExperiencePoints(storedExperiencePoints - experienceBottleCount * 7);
            this.playSound(SoundEvents.BOTTLE_FILL_DRAGONBREATH, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public static AttributeSupplier.Builder createMaulerAttributes() {
        return Mob.createMobAttributes().add(Attributes.SCALE, 1.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    public boolean isPushable() {
        return !this.isBurrowedDown() && super.isPushable();
    }

    public void doPush(Entity entity) {
        if (this.isBurrowedDown()) {
            return;
        }
        super.doPush(entity);
    }

    public void setEntityPose(FriendsAndFoesEntityPose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        this.entityData.set(ENTITY_POSE, (Object)pose);
    }

    public FriendsAndFoesEntityPose getEntityPose() {
        return (FriendsAndFoesEntityPose)((Object)this.entityData.get(ENTITY_POSE));
    }

    public boolean isInEntityPose(FriendsAndFoesEntityPose pose) {
        return this.getEntityPose() == pose;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_MAULER_GROWL.get();
    }

    public void playAmbientSound() {
        if (this.isAngry() && this.isMoving() || this.isBurrowedDown()) {
            return;
        }
        this.playSound(this.getAmbientSound(), 0.5f, RandomGenerator.generateFloat(0.75f, 0.85f));
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_MAULER_HURT.get();
    }

    public void playHurtSound(DamageSource source) {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.playSound(this.getHurtSound(source), 0.5f, RandomGenerator.generateFloat(0.85f, 0.95f));
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_MAULER_DEATH.get();
    }

    public void playStepSound(BlockPos pos, BlockState state) {
        super.playStepSound(pos, state);
        if (this.isAngry() && this.isMoving() && this.onGround() && this.getDeltaMovement().y() <= 1.0E-4) {
            this.playSound((SoundEvent)FriendsAndFoesSoundEvents.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
        }
    }

    public boolean doHurtTarget(ServerLevel level, Entity target) {
        if (this.isBurrowedDown()) {
            return false;
        }
        return VersionedEntity.hurt(target, this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.entityData.set(ANGER_TIME, (Object)angerTime);
    }

    public void startPersistentAngerTimer() {
        int angerTime = this.getRandom().nextIntBetweenInclusive(400, 1000);
        this.setRemainingPersistentAngerTime(angerTime);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public Type getMaulerType() {
        return Type.fromName((String)this.entityData.get(TYPE));
    }

    private void setType(Type type) {
        this.entityData.set(TYPE, (Object)type.name);
    }

    public int getStoredExperiencePoints() {
        return (Integer)this.entityData.get(STORED_EXPERIENCE_POINTS);
    }

    public void setStoredExperiencePoints(int storedExperiencePoints) {
        this.entityData.set(STORED_EXPERIENCE_POINTS, (Object)storedExperiencePoints);
        this.xpReward = storedExperiencePoints;
    }

    public void setSize() {
        float size = this.getSize();
        this.getAttribute(Attributes.SCALE).setBaseValue((double)this.getSize());
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)((int)(20.0f * size)));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)(8.0f * (size / 2.0f)));
        this.refreshDimensions();
        this.makeBoundingBox();
    }

    public float getSize() {
        return 1.0f + (float)this.getStoredExperiencePoints() / 1395.0f * 1.25f;
    }

    public float getAgeScale() {
        return this.getSize();
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(IS_MOVING);
    }

    public void setMoving(boolean isMoving) {
        this.entityData.set(IS_MOVING, (Object)isMoving);
    }

    public boolean isBurrowedDown() {
        return (Boolean)this.entityData.get(IS_BURROWED_DOWN);
    }

    public void setBurrowedDown(boolean isBurrowedDown) {
        this.entityData.set(IS_BURROWED_DOWN, (Object)isBurrowedDown);
    }

    public int getTicksUntilNextBurrowingDown() {
        return (Integer)this.entityData.get(TICKS_UNTIL_NEXT_BURROWING_DOWN);
    }

    public void setTicksUntilNextBurrowingDown(int ticksUntilNextBurrowingDown) {
        this.entityData.set(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)ticksUntilNextBurrowingDown);
    }

    public float getBurrowingDownAnimationProgress() {
        return ((Float)this.entityData.get(BURROWING_DOWN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setBurrowingDownAnimationProgress(float burrowingDownAnimationProgress) {
        this.entityData.set(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(burrowingDownAnimationProgress));
    }

    private void updateBurrowingDownAnimation() {
        if (this.isBurrowedDown()) {
            this.setBurrowingDownAnimationProgress(Math.min(1.0f, this.getBurrowingDownAnimationProgress() + 0.04f));
        } else {
            this.setBurrowingDownAnimationProgress(Math.max(0.0f, this.getBurrowingDownAnimationProgress() - 0.04f));
        }
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    private int getExperiencePoints(ItemStack stack) {
        int i = 0;
        ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
            Holder registryEntry = (Holder)entry.getKey();
            int j = entry.getIntValue();
            if (registryEntry.is(EnchantmentTags.CURSE)) continue;
            i += ((Enchantment)registryEntry.value()).getMinCost(j);
        }
        return i;
    }

    public void spawnParticles(ParticleOptions particleEffect, int amount) {
        Level world = this.level();
        if (world.isClientSide()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)world).sendParticles(particleEffect, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 1, this.getRandom().nextGaussian() * 0.02, this.getRandom().nextGaussian() * 0.02, this.getRandom().nextGaussian() * 0.02, 1.0);
        }
    }

    static {
        ENTITY_POSE = SynchedEntityData.defineId(MaulerEntity.class, FriendsAndFoesEntityDataSerializers.ENTITY_POSE);
        TYPE = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        ANGER_TIME = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        STORED_EXPERIENCE_POINTS = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        IS_MOVING = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        IS_BURROWED_DOWN = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        TICKS_UNTIL_NEXT_BURROWING_DOWN = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        BURROWING_DOWN_ANIMATION_PROGRESS = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
        POSE_TICKS = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }

    public static enum Type {
        BADLANDS("badlands"),
        DESERT("desert"),
        SAVANNA("savanna");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Type fromName(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return SAVANNA;
        }

        public static Type getTypeByBiome(ResourceKey<Biome> biome) {
            if (biome == Biomes.DESERT) {
                return DESERT;
            }
            if (biome == Biomes.BADLANDS || biome == Biomes.ERODED_BADLANDS || biome == Biomes.WOODED_BADLANDS) {
                return BADLANDS;
            }
            return SAVANNA;
        }
    }
}

