/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json;

import com.faboslav.friendsandfoes.common.entity.animation.AnimationChannel;
import com.faboslav.friendsandfoes.common.entity.animation.AnimationDefinition;
import com.faboslav.friendsandfoes.common.entity.animation.animator.Keyframe;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.AnimationKeyframeTarget;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.AnimationTarget;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationTypeManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public final class AnimationParser {
    private static final Codec<AnimationTarget> TARGET_CODEC = ResourceLocation.CODEC.flatXmap(name -> Optional.ofNullable(AnimationTypeManager.getTarget(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Animation target '%s' not found. Registered targets: %s", name, AnimationTypeManager.getTargetList()))), target -> Optional.ofNullable(AnimationTypeManager.getTargetName(target)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Unregistered animation target '%s'. Registered targets: %s", target, AnimationTypeManager.getTargetList()))));
    private static final Codec<AnimationChannel.Interpolation> INTERPOLATION_CODEC = ResourceLocation.CODEC.flatXmap(name -> Optional.ofNullable(AnimationTypeManager.getInterpolation(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Animation interpolation '%s' not found. Registered interpolations: %s", name, AnimationTypeManager.getInterpolationList()))), target -> Optional.ofNullable(AnimationTypeManager.getInterpolationName(target)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Unregistered animation interpolation '%s'. Registered interpolations: %s", target, AnimationTypeManager.getInterpolationList()))));
    public static final MapCodec<AnimationChannel> CHANNEL_CODEC = new KeyDispatchCodec("target", TARGET_CODEC, channel -> Optional.ofNullable(AnimationTypeManager.getTargetFromChannelTarget(channel.target())).map(DataResult::success).orElseGet(() -> DataResult.error(() -> String.format(Locale.ENGLISH, "Unregistered animation channel target '%s'. Registered targets: %s", new Object[]{channel.target(), AnimationTypeManager.getTargetList()}))), target -> DataResult.success((Object)Optional.ofNullable(AnimationTypeManager.getKeyframeCodec(target)).orElseGet(() -> AnimationParser.keyframeCodec(target)).listOf().xmap(keyframes -> new AnimationChannel(target.channelTarget(), (Keyframe[])keyframes.toArray(Keyframe[]::new)), channel -> Arrays.asList(channel.keyframes())).fieldOf("keyframes")));
    private static final Codec<Pair<String, AnimationChannel>> NAMED_CHANNEL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("bone").forGetter(Pair::key), (App)CHANNEL_CODEC.forGetter(Pair::value)).apply((Applicative)instance, Pair::of));
    public static final Codec<AnimationDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("length").forGetter(AnimationDefinition::lengthInSeconds), (App)Codec.BOOL.optionalFieldOf("loop", (Object)false).forGetter(AnimationDefinition::looping), (App)NAMED_CHANNEL_CODEC.listOf().xmap(list -> {
        HashMap<String, List> result = new HashMap<String, List>();
        for (Pair animation : list) {
            result.computeIfAbsent((String)animation.key(), k -> new ArrayList()).add((AnimationChannel)animation.value());
        }
        return result;
    }, map -> {
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (Map.Entry entry : map.entrySet()) {
            for (AnimationChannel channel : (List)entry.getValue()) {
                result.add(Pair.of((Object)((String)entry.getKey()), (Object)channel));
            }
        }
        return result;
    }).fieldOf("animations").forGetter(AnimationDefinition::boneAnimations)).apply((Applicative)instance, (lengthInSeconds, looping, boneAnimations) -> new AnimationDefinition("", lengthInSeconds.floatValue(), (boolean)looping, (Map<String, List<AnimationChannel>>)boneAnimations)));

    private AnimationParser() {
    }

    static Codec<Keyframe> keyframeCodec(AnimationTarget target) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("timestamp").forGetter(Keyframe::timestamp), (App)ExtraCodecs.VECTOR3F.xmap(AnimationParser.keyframeTargetToUnaryOp(target.keyframeTarget()), AnimationParser.keyframeTargetToUnaryOp(target.inverseKeyframeTarget())).fieldOf("target").forGetter(Keyframe::target), (App)INTERPOLATION_CODEC.fieldOf("interpolation").forGetter(Keyframe::interpolation)).apply((Applicative)instance, Keyframe::new));
    }

    private static UnaryOperator<Vector3f> keyframeTargetToUnaryOp(AnimationKeyframeTarget target) {
        return vec -> target.apply(vec.x, vec.y, vec.z);
    }
}

