/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.model.animation.KeyframeModelAnimator;
import com.faboslav.friendsandfoes.common.client.render.entity.state.MaulerRenderState;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.entity.animation.MaulerAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import java.util.ArrayList;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class MaulerEntityModel
extends EntityModel<MaulerRenderState> {
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_UPPER_JAW = "upperJaw";
    private static final String MODEL_PART_LOWER_JAW = "lowerJaw";
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_FRONT_LEFT_LEG = "frontLeftLeg";
    private static final String MODEL_PART_FRONT_RIGHT_LEG = "frontRightLeg";
    private static final String MODEL_PART_BACK_LEFT_LEG = "backLeftLeg";
    private static final String MODEL_PART_BACK_RIGHT_LEG = "backRightLeg";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart upperJaw;
    private final ModelPart lowerJaw;
    private final ModelPart body;
    private final ModelPart frontLeftLeg;
    private final ModelPart frontRightLeg;
    private final ModelPart backLeftLeg;
    private final ModelPart backRightLeg;

    public MaulerEntityModel(ModelPart root) {
        super(root);
        this.root = root;
        this.head = this.root.getChild(MODEL_PART_HEAD);
        this.upperJaw = this.head.getChild(MODEL_PART_UPPER_JAW);
        this.lowerJaw = this.head.getChild(MODEL_PART_LOWER_JAW);
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.frontLeftLeg = this.root.getChild(MODEL_PART_FRONT_LEFT_LEG);
        this.frontRightLeg = this.root.getChild(MODEL_PART_FRONT_RIGHT_LEG);
        this.backLeftLeg = this.root.getChild(MODEL_PART_BACK_LEFT_LEG);
        this.backRightLeg = this.root.getChild(MODEL_PART_BACK_RIGHT_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition head = root.getChild(MODEL_PART_HEAD);
        head.addOrReplaceChild(MODEL_PART_UPPER_JAW, CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -3.0f, -10.0f, 9.0f, 3.0f, 10.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)1.0f));
        head.addOrReplaceChild(MODEL_PART_LOWER_JAW, CubeListBuilder.create().texOffs(0, 13).addBox(-4.5f, 0.0f, -10.0f, 9.0f, 3.0f, 10.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)1.0f));
        root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(0, 26).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)20.0f, (float)1.0f));
        root.addOrReplaceChild(MODEL_PART_FRONT_LEFT_LEG, CubeListBuilder.create().texOffs(0, 5).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)2.5f, (float)21.0f, (float)-1.0f));
        root.addOrReplaceChild(MODEL_PART_FRONT_RIGHT_LEG, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)-2.5f, (float)21.0f, (float)-1.0f));
        root.addOrReplaceChild(MODEL_PART_BACK_LEFT_LEG, CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)2.5f, (float)21.0f, (float)3.0f));
        root.addOrReplaceChild(MODEL_PART_BACK_RIGHT_LEG, CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)-2.5f, (float)21.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setupAnim(MaulerRenderState renderState) {
        MaulerEntity mauler = renderState.mauler;
        float limbAngle = renderState.walkAnimationPos;
        float limbDistance = renderState.walkAnimationSpeed;
        float animationProgress = renderState.ageInTicks;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateKeyframeAnimations(mauler, limbAngle, limbDistance, animationProgress);
    }

    public void updateKeyframeAnimations(MaulerEntity mauler, float limbAngle, float limbDistance, float animationProgress) {
        AnimationHolder movementAnimation = mauler.getMovementAnimation();
        ArrayList<AnimationHolder> animations = mauler.getTrackedAnimations();
        AnimationContextTracker animationContextTracker = mauler.getAnimationContextTracker();
        int currentTick = mauler.tickCount;
        float animationSpeedModifier = mauler.getAnimationSpeedModifier();
        KeyframeModelAnimator.updateMovementKeyframeAnimations(this, movementAnimation, limbAngle, limbDistance, 2.5f, 3.5f, animationSpeedModifier);
        if (mauler.isAngry()) {
            KeyframeModelAnimator.updateStaticKeyframeAnimation(this, animationContextTracker, MaulerAnimations.SNAP, currentTick, animationProgress, animationSpeedModifier);
        }
        KeyframeModelAnimator.updateKeyframeAnimations(this, animationContextTracker, animations, currentTick, animationProgress, animationSpeedModifier);
    }
}

