/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.state.IllusionerRenderState;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.SpellcasterIllager;

public class IllusionerEntityRenderer<T extends SpellcasterIllager>
extends IllagerRenderer<T, IllusionerRenderState> {
    private static final ResourceLocation TEXTURE = FriendsAndFoes.makeID("textures/entity/illusioner/illusioner.png");

    public IllusionerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new IllagerModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.ILLUSIONER_LAYER)), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer<IllusionerRenderState, IllagerModel<IllusionerRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, IllusionerRenderState renderState, float f, float g) {
                if (renderState.isCastingSpell || renderState.isAggressive) {
                    super.submit(poseStack, submitNodeCollector, i, (ArmedEntityRenderState)renderState, f, g);
                }
            }
        });
        ((IllagerModel)this.model).getHat().visible = true;
    }

    public IllusionerRenderState createRenderState() {
        return new IllusionerRenderState();
    }

    public void extractRenderState(T illusioner, IllusionerRenderState renderState, float partialTick) {
        super.extractRenderState(illusioner, (IllagerRenderState)renderState, partialTick);
        renderState.isCastingSpell = illusioner.isCastingSpell();
    }

    public ResourceLocation getTextureLocation(IllusionerRenderState renderState) {
        return TEXTURE;
    }
}

