/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.entity.MannequinEntityAccess;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.mixin.MannequinAvatarMixin;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Mannequin.class})
public abstract class MannequinMixin
extends MannequinAvatarMixin
implements MannequinEntityAccess {
    @Unique
    private static final String FRIENDSANDFOES_IS_ILLUSION_NBT_NAME = "FriendsAndFoesIsIllusion";
    @Unique
    private static final String FRIENDSANDFOES_TICKS_UNTIL_DESPAWN_NBT_NAME = "FriendsAndFoesTicksUntilDespawn";
    @Unique
    private boolean friendsandfoes$isIllusion = false;
    @Unique
    private int friendsandfoes$ticksUntilDespawn = 0;
    @Unique
    private Optional<UUID> friendsandfoes$playerUuid = Optional.empty();
    @Unique
    @Nullable
    private Player friendsandfoes$player = null;

    @Override
    @Unique
    public void friendsandfoes$setPlayerUuid(@Nullable UUID uuid) {
        this.friendsandfoes$playerUuid = Optional.ofNullable(uuid);
    }

    @Nullable
    public Player friendsandfoes$getPlayer() {
        return this.friendsandfoes$player;
    }

    @Override
    public void friendsandfoes$setPlayer(Player player) {
        this.friendsandfoes$player = player;
    }

    @Override
    public void friendsandfoes$setIsIllusion(boolean isIllusion) {
        this.friendsandfoes$isIllusion = isIllusion;
    }

    @Override
    public void friendsandfoes$setTicksUntilDespawn(int ticksUntilDespawn) {
        this.friendsandfoes$ticksUntilDespawn = ticksUntilDespawn;
    }

    private void friendsandfoes$discardIllusion() {
        this.friendsandfoes$playMirrorSound();
        ParticleSpawner.spawnParticles((LivingEntity)((Mannequin)this), (ParticleOptions)ParticleTypes.CLOUD, 16, 0.1);
        this.discard();
    }

    private void friendsandfoes$playMirrorSound() {
        this.playSound((SoundEvent)FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.getSoundVolume(), this.getVoicePitch());
    }

    @Override
    protected void friendsandfoes$readAdditionalSaveData(ValueInput valueInput, Operation<Void> original) {
        super.friendsandfoes$readAdditionalSaveData(valueInput, original);
        this.friendsandfoes$setIsIllusion(valueInput.getBooleanOr(FRIENDSANDFOES_IS_ILLUSION_NBT_NAME, false));
        this.friendsandfoes$setTicksUntilDespawn(valueInput.getIntOr(FRIENDSANDFOES_TICKS_UNTIL_DESPAWN_NBT_NAME, 0));
    }

    @Override
    protected void friendsandfoes$addAdditionalSaveData(ValueOutput valueOutput, Operation<Void> original) {
        super.friendsandfoes$addAdditionalSaveData(valueOutput, original);
        valueOutput.putBoolean(FRIENDSANDFOES_IS_ILLUSION_NBT_NAME, this.friendsandfoes$isIllusion);
        valueOutput.putInt(FRIENDSANDFOES_TICKS_UNTIL_DESPAWN_NBT_NAME, this.friendsandfoes$ticksUntilDespawn);
    }

    @Override
    protected void friendsandfoes$aiStep(Operation<Void> original) {
        boolean isPlayerNonExistingOrDead;
        super.friendsandfoes$aiStep(original);
        if (this.level().isClientSide() || !this.friendsandfoes$isIllusion) {
            return;
        }
        if (this.friendsandfoes$ticksUntilDespawn > 0) {
            this.friendsandfoes$setTicksUntilDespawn(this.friendsandfoes$ticksUntilDespawn - 1);
        }
        boolean bl = isPlayerNonExistingOrDead = this.friendsandfoes$getPlayer() != null && !this.friendsandfoes$getPlayer().isAlive();
        if (this.friendsandfoes$ticksUntilDespawn == 0 || isPlayerNonExistingOrDead) {
            this.friendsandfoes$discardIllusion();
        }
    }

    @Override
    protected boolean friendsandfoes$mannequinHurtServer(ServerLevel serverLevel, DamageSource damageSource, float f, Operation<Boolean> original) {
        if (!this.friendsandfoes$isIllusion) {
            return super.friendsandfoes$mannequinHurtServer(serverLevel, damageSource, f, original);
        }
        this.friendsandfoes$discardIllusion();
        return false;
    }
}

