/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class IllusionerEntity
extends SpellcasterIllager
implements RangedAttackMob {
    private static final int MAX_ILLUSIONS_COUNT = FriendsAndFoes.getConfig().illusionerMaxIllusionsCount;
    private static final int ILLUSION_LIFETIME_TICKS = FriendsAndFoes.getConfig().illusionerIllusionLifetimeTicks;
    private static final int INVISIBILITY_TICKS = FriendsAndFoes.getConfig().illusionerInvisibilityTicks;
    private static final String IS_ILLUSION_NBT_NAME = "IsIllusion";
    private static final String WAS_ATTACKED_NBT_NAME = "WasAttacked";
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final String TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME = "TicksUntilCanCreateIllusions";
    private IllusionerEntity illusioner;
    private boolean isIllusion;
    private boolean wasAttacked;
    private int ticksUntilDespawn;
    private int ticksUntilCanCreateIllusion;

    public IllusionerEntity(EntityType<? extends IllusionerEntity> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
        this.illusioner = null;
        this.isIllusion = false;
        this.wasAttacked = false;
        this.ticksUntilDespawn = 0;
        this.ticksUntilCanCreateIllusion = 0;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new IllusionerBlindnessSpellGoal());
        this.goalSelector.addGoal(6, (Goal)new RangedBowAttackGoal((Monster)this, 0.5, 20, 15.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PlayerIllusionEntity.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false).setUnseenMemoryTicks(300));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean(IS_ILLUSION_NBT_NAME, this.isIllusion());
        nbt.putBoolean(WAS_ATTACKED_NBT_NAME, this.wasAttacked());
        nbt.putInt(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        nbt.putInt(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME, this.getTicksUntilCanCreateIllusions());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setIsIllusion(VersionedNbt.getBoolean(nbt, IS_ILLUSION_NBT_NAME, false));
        this.setWasAttacked(VersionedNbt.getBoolean(nbt, WAS_ATTACKED_NBT_NAME, false));
        this.setTicksUntilDespawn(VersionedNbt.getInt(nbt, TICKS_UNTIL_DESPAWN_NBT_NAME, 0));
        this.setTicksUntilCanCreateIllusions(VersionedNbt.getInt(nbt, TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME, 0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 18.0).add(Attributes.MAX_HEALTH, 24.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        return super.finalizeSpawn(level, difficulty, spawnReason, entityData);
    }

    public void tick() {
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            this.discard();
        }
        super.tick();
    }

    public void aiStep() {
        boolean isIllusionerNonExistingOrDead;
        super.aiStep();
        if (this.level().isClientSide()) {
            return;
        }
        if (this.getTicksUntilCanCreateIllusions() > 0) {
            this.setTicksUntilCanCreateIllusions(this.getTicksUntilCanCreateIllusions() - 1);
        }
        if (this.wasAttacked() && this.getTicksUntilCanCreateIllusions() == 0) {
            this.createIllusions();
        }
        if (this.wasAttacked() && this.getTarget() == null && this.getTicksUntilCanCreateIllusions() < ILLUSION_LIFETIME_TICKS / 3) {
            this.setWasAttacked(false);
            this.setTicksUntilCanCreateIllusions(0);
        }
        if (!this.isIllusion()) {
            return;
        }
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isIllusionerNonExistingOrDead = this.getIllusioner() != null && !this.getIllusioner().isAlive();
        if (this.getTicksUntilDespawn() == 0 || isIllusionerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        block6: {
            block7: {
                Entity attacker = damageSource.getEntity();
                EntityType attackerType = null;
                if (attacker != null) {
                    attackerType = attacker.getType();
                }
                if (attackerType != null && (attackerType.is(EntityTypeTags.ILLAGER_FRIENDS) || attackerType.is(EntityTypeTags.RAIDERS)) || this.isIllusion() && !(attacker instanceof LivingEntity)) {
                    return false;
                }
                if (this.level().isClientSide() || attackerType == null || attackerType.is(EntityTypeTags.ILLAGER_FRIENDS) || attackerType.is(EntityTypeTags.RAIDERS)) break block6;
                if (this.isIllusion()) {
                    this.discardIllusion();
                    return false;
                }
                if (this.getTicksUntilCanCreateIllusions() != 0 || attackerType.is(EntityTypeTags.ILLAGER_FRIENDS) || attackerType.is(EntityTypeTags.RAIDERS)) break block6;
                Entity entity = damageSource.getEntity();
                if (!(entity instanceof Player)) break block7;
                Player player = (Player)entity;
                if (player.getAbilities().instabuild) break block6;
            }
            this.createIllusions();
        }
        return super.hurtServer(level, damageSource, amount);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ILLUSIONER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ILLUSIONER_HURT;
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.ILLUSIONER_CAST_SPELL;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        ItemStack itemStack = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
        ItemStack itemStack2 = this.getProjectile(itemStack);
        AbstractArrow abstractArrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemStack2, (float)velocity, (ItemStack)itemStack);
        double d = target.getX() - this.getX();
        double e = target.getY(0.3333333333333333) - abstractArrow.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f);
        Level var15 = this.level();
        if (var15 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var15;
            Projectile.spawnProjectileUsingShoot((Projectile)abstractArrow, (ServerLevel)serverLevel, (ItemStack)itemStack2, (double)d, (double)(e + g * (double)0.2f), (double)f, (float)1.6f, (float)(14 - serverLevel.getDifficulty().getId() * 4));
        }
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.isAggressive() ? AbstractIllager.IllagerArmPose.BOW_AND_ARROW : AbstractIllager.IllagerArmPose.CROSSED;
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.discard();
    }

    private void createIllusions() {
        this.setWasAttacked(true);
        this.setTicksUntilCanCreateIllusions(ILLUSION_LIFETIME_TICKS);
        this.playMirrorSound();
        this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, INVISIBILITY_TICKS));
        this.spawnCloudParticles();
        if (MAX_ILLUSIONS_COUNT == 0) {
            return;
        }
        Vec3 illusionerPosition = this.position();
        float slice = (float)Math.PI * 2 / (float)MAX_ILLUSIONS_COUNT;
        int radius = 9;
        int randomPoint = this.getRandom().nextIntBetweenInclusive(0, MAX_ILLUSIONS_COUNT - 1);
        for (int point = 0; point < MAX_ILLUSIONS_COUNT; ++point) {
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.x() + (double)((float)radius * Mth.cos((float)angle)));
            int y = (int)illusionerPosition.y();
            int z = (int)(illusionerPosition.z() + (double)((float)radius * Mth.sin((float)angle)));
            if (randomPoint == point) {
                this.tryToTeleport(x, y, z);
                continue;
            }
            this.createIllusion(x, y, z);
        }
    }

    private void createIllusion(int x, int y, int z) {
        IllusionerEntity illusioner = this;
        IllusionerEntity illusion = (IllusionerEntity)((EntityType)FriendsAndFoesEntityTypes.ILLUSIONER.get()).create(this.level(), EntitySpawnReason.MOB_SUMMONED);
        illusion.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        illusion.setIsIllusion(true);
        illusion.setIllusioner(illusioner);
        illusion.setTicksUntilDespawn(ILLUSION_LIFETIME_TICKS);
        illusion.setHealth(this.getMaxHealth());
        illusion.copyPosition((Entity)illusioner);
        boolean teleportResult = this.tryToTeleport(x, y, z);
        if (teleportResult) {
            this.level().addFreshEntity((Entity)illusion);
            this.spawnCloudParticles();
        }
    }

    public boolean tryToTeleport(int x, int y, int z) {
        int worldBottomY = this.level().getMinY();
        double bottomY = Math.max(y -= 8, worldBottomY);
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)this.level()).getLogicalHeight() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.randomTeleport(x, y = (int)Mth.clamp((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private void playMirrorSound() {
        this.playSound(SoundEvents.ILLUSIONER_MIRROR_MOVE, this.getSoundVolume(), this.getVoicePitch());
    }

    public void spawnCloudParticles() {
        this.spawnParticles(ParticleTypes.CLOUD, 16);
    }

    private <T extends ParticleOptions> void spawnParticles(T particleType, int amount) {
        if (this.level().isClientSide()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)this.level()).sendParticles(particleType, this.getRandomX(0.5), this.getRandomY() + 0.5, this.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isIllusion() {
        return this.isIllusion;
    }

    public void setIsIllusion(boolean isIllusion) {
        this.isIllusion = isIllusion;
    }

    public boolean wasAttacked() {
        return this.wasAttacked;
    }

    public void setWasAttacked(boolean wasAttacked) {
        this.wasAttacked = wasAttacked;
    }

    @Nullable
    public IllusionerEntity getIllusioner() {
        return this.illusioner;
    }

    public void setIllusioner(IllusionerEntity illusioner) {
        this.illusioner = illusioner;
    }

    public int getTicksUntilDespawn() {
        return this.ticksUntilDespawn;
    }

    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.ticksUntilDespawn = ticksUntilDespawn;
    }

    public int getTicksUntilCanCreateIllusions() {
        return this.ticksUntilCanCreateIllusion;
    }

    public void setTicksUntilCanCreateIllusions(int ticksUntilCanCreateIllusions) {
        this.ticksUntilCanCreateIllusion = ticksUntilCanCreateIllusions;
    }

    public class IllusionerBlindnessSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private int lastTargetId;

        IllusionerBlindnessSpellGoal() {
            super((SpellcasterIllager)IllusionerEntity.this);
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            if (IllusionerEntity.this.getTarget() == null) {
                return false;
            }
            if (IllusionerEntity.this.getTarget().getId() == this.lastTargetId) {
                return false;
            }
            return IllusionerEntity.this.level().getCurrentDifficultyAt(IllusionerEntity.this.blockPosition()).isHarderThan((float)Difficulty.NORMAL.ordinal());
        }

        public void start() {
            super.start();
            LivingEntity livingEntity = IllusionerEntity.this.getTarget();
            if (livingEntity != null) {
                this.lastTargetId = livingEntity.getId();
            }
        }

        protected int getCastingTime() {
            return 20;
        }

        protected int getCastingInterval() {
            return 180;
        }

        protected void performSpellCasting() {
            IllusionerEntity.this.getTarget().addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200), (Entity)IllusionerEntity.this);
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.ILLUSIONER_PREPARE_BLINDNESS;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }
}

