/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.world.processor;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class CitadelBottomProcessor
extends StructureProcessor {
    public static final MapCodec<CitadelBottomProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockState.CODEC.fieldOf("target_block_output").forGetter(config -> config.targetBlockOutput), (App)Direction.CODEC.optionalFieldOf("direction", (Object)Direction.DOWN).forGetter(processor -> processor.direction), (App)Codec.INT.optionalFieldOf("pillar_length", (Object)-1).forGetter(config -> config.length)).apply((Applicative)instance, instance.stable(CitadelBottomProcessor::new)));
    public final BlockState targetBlock;
    public final BlockState targetBlockOutput;
    public final Direction direction;
    public final int length;

    private CitadelBottomProcessor(BlockState targetBlock, BlockState targetBlockOutput, Direction direction, int length) {
        this.targetBlock = targetBlock;
        this.targetBlockOutput = targetBlockOutput;
        this.direction = direction;
        this.length = length;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(this.targetBlock.getBlock())) {
            WorldGenRegion chunkRegion;
            if (worldView instanceof WorldGenRegion && !(chunkRegion = (WorldGenRegion)worldView).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), this.targetBlockOutput, blockInfoGlobal.nbt());
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().mutable().move(Direction.DOWN);
            BlockState currentBlockState = worldView.getBlockState((BlockPos)mutable);
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            int worldBottomY = worldView.getMinY();
            int worldTopY = worldView.getMaxY();
            while (mutable.getY() > worldBottomY && mutable.getY() < worldTopY && (currentBlockState.isAir() || !worldView.getFluidState((BlockPos)mutable).isEmpty())) {
                worldView.getChunk((BlockPos)mutable).setBlockState((BlockPos)mutable, this.targetBlockOutput);
                mutable.move(Direction.DOWN);
                currentBlockState = worldView.getBlockState((BlockPos)mutable);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)FriendsAndFoesStructureProcessorTypes.CITADEL_BOTTOM_PROCESSOR.get();
    }
}

