/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.client.render.entity.feature.PlayerIllusionCapeLayer;
import com.faboslav.friendsandfoes.common.client.render.entity.model.PlayerIllusionEntityModel;
import com.faboslav.friendsandfoes.common.client.render.entity.state.PlayerIllusionRenderState;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.util.PlayerSkinProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;

public final class PlayerIllusionEntityRenderer
extends LivingEntityRenderer<PlayerIllusionEntity, PlayerRenderState, PlayerIllusionEntityModel> {
    public PlayerIllusionEntityRenderer(EntityRendererProvider.Context context, boolean useSlimModel) {
        super(context, (EntityModel)new PlayerIllusionEntityModel(context.bakeLayer(useSlimModel ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), useSlimModel), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(useSlimModel ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(useSlimModel ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new ArrowLayer((LivingEntityRenderer)this, context));
        this.addLayer(new PlayerIllusionCapeLayer((RenderLayerParent<PlayerRenderState, PlayerIllusionEntityModel>)this, context.getModelSet(), context.getEquipmentAssets()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new WingsLayer((RenderLayerParent)this, context.getModelSet(), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this, context));
    }

    protected void scale(PlayerRenderState renderState, PoseStack poseStack) {
        float scale = 0.9375f;
        poseStack.scale(scale, scale, scale);
    }

    public PlayerIllusionRenderState createRenderState() {
        return new PlayerIllusionRenderState();
    }

    public void extractRenderState(PlayerIllusionEntity playerIllusion, PlayerRenderState playerIllusionRenderState, float partialTick) {
        super.extractRenderState((LivingEntity)playerIllusion, (LivingEntityRenderState)playerIllusionRenderState, partialTick);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)playerIllusion, (HumanoidRenderState)playerIllusionRenderState, (float)partialTick, (ItemModelResolver)this.itemModelResolver);
        playerIllusionRenderState.leftArmPose = PlayerIllusionEntityRenderer.getArmPose(playerIllusion, HumanoidArm.LEFT);
        playerIllusionRenderState.rightArmPose = PlayerIllusionEntityRenderer.getArmPose(playerIllusion, HumanoidArm.RIGHT);
        playerIllusionRenderState.skin = PlayerSkinProvider.getSkinTextures(playerIllusion);
        playerIllusionRenderState.arrowCount = playerIllusion.getArrowCount();
        playerIllusionRenderState.stingerCount = playerIllusion.getStingerCount();
        playerIllusionRenderState.useItemRemainingTicks = playerIllusion.getUseItemRemainingTicks();
        playerIllusionRenderState.showHat = playerIllusion.isPartVisible(PlayerModelPart.HAT);
        playerIllusionRenderState.showJacket = playerIllusion.isPartVisible(PlayerModelPart.JACKET);
        playerIllusionRenderState.showLeftPants = playerIllusion.isPartVisible(PlayerModelPart.LEFT_PANTS_LEG);
        playerIllusionRenderState.showRightPants = playerIllusion.isPartVisible(PlayerModelPart.RIGHT_PANTS_LEG);
        playerIllusionRenderState.showLeftSleeve = playerIllusion.isPartVisible(PlayerModelPart.LEFT_SLEEVE);
        playerIllusionRenderState.showRightSleeve = playerIllusion.isPartVisible(PlayerModelPart.RIGHT_SLEEVE);
        playerIllusionRenderState.showCape = playerIllusion.isPartVisible(PlayerModelPart.CAPE);
    }

    private static HumanoidModel.ArmPose getArmPose(PlayerIllusionEntity playerIllusion, HumanoidArm humanoidArm) {
        ItemStack itemStack = playerIllusion.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack itemStack2 = playerIllusion.getItemInHand(InteractionHand.OFF_HAND);
        HumanoidModel.ArmPose armPose = PlayerIllusionEntityRenderer.getArmPose(playerIllusion, itemStack, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose armPose2 = PlayerIllusionEntityRenderer.getArmPose(playerIllusion, itemStack2, InteractionHand.OFF_HAND);
        if (armPose.isTwoHanded()) {
            armPose2 = itemStack2.isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        return playerIllusion.getMainArm() == humanoidArm ? armPose : armPose2;
    }

    private static HumanoidModel.ArmPose getArmPose(PlayerIllusionEntity playerIllusion, ItemStack itemStack, InteractionHand interactionHand) {
        if (itemStack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (!playerIllusion.swinging && itemStack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if (playerIllusion.getUsedItemHand() == interactionHand && playerIllusion.getUseItemRemainingTicks() > 0) {
            ItemUseAnimation itemUseAnimation = itemStack.getUseAnimation();
            if (itemUseAnimation == ItemUseAnimation.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (itemUseAnimation == ItemUseAnimation.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (itemUseAnimation == ItemUseAnimation.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (itemUseAnimation == ItemUseAnimation.CROSSBOW) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (itemUseAnimation == ItemUseAnimation.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (itemUseAnimation == ItemUseAnimation.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (itemUseAnimation == ItemUseAnimation.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void renderNameTag(PlayerRenderState renderState, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
    }

    public ResourceLocation getTextureLocation(PlayerRenderState playerIllusionRenderState) {
        return playerIllusionRenderState.skin.texture();
    }
}

