/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.beacon;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.mixins.tweaks.features.infoView.beacon.BeaconBlockEntityAccessor;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.render.InWorldPositionTransformer;
import me.fallenbreath.tweakermore.util.render.RenderUtils;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import me.fallenbreath.tweakermore.util.render.context.RenderGlobals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class BeaconEffectRenderer
extends CommonScannerInfoViewer {
    private static final double FONT_SCALE = 0.025;
    private static final double MARGIN = 5.0;
    private static final int ICON_SIZE = 18;
    private static final int ICON_RENDERED_SIZE = RenderUtils.TEXT_HEIGHT;

    public BeaconEffectRenderer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_BEACON, TweakerMoreConfigs.INFO_VIEW_BEACON_RENDER_STRATEGY, TweakerMoreConfigs.INFO_VIEW_BEACON_TARGET_STRATEGY);
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() instanceof BeaconBlock && world.getBlockEntity(pos) instanceof BeaconBlockEntity;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, BlockPos pos) {
        return true;
    }

    @Override
    protected void render(RenderContext context, RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof BeaconBlockEntity)) {
            return;
        }
        BeaconBlockEntityAccessor accessor = (BeaconBlockEntityAccessor)blockEntity;
        int beaconLevel = accessor.getLevel();
        MobEffect primary = Optional.ofNullable(accessor.getPrimary()).map(Holder::value).orElse(null);
        MobEffect secondary = Optional.ofNullable(accessor.getSecondary()).map(Holder::value).orElse(null);
        if (primary != null) {
            ArrayList effects = Lists.newArrayList();
            effects.add(Pair.of((Object)primary, (Object)(beaconLevel >= 4 && primary == secondary ? 1 : 0)));
            if (beaconLevel >= 4 && primary != secondary && secondary != null) {
                effects.add(Pair.of((Object)secondary, (Object)0));
            }
            Vec3 centerPos = PositionUtils.centerOf(pos);
            double maxWidth = effects.stream().mapToDouble(pair -> this.calculateRowWidth((MobEffect)pair.getFirst(), (Integer)pair.getSecond())).max().orElse(0.0);
            for (int i = 0; i < effects.size(); ++i) {
                Pair pair2 = (Pair)effects.get(i);
                MobEffect statusEffect = (MobEffect)pair2.getFirst();
                int amplifier = (Integer)pair2.getSecond();
                double deltaX = -maxWidth / 2.0;
                double kDeltaY = (double)i - (double)(effects.size() - 1) / 2.0;
                this.renderStatusEffectIcon(centerPos, statusEffect, amplifier, deltaX, kDeltaY);
                this.renderStatusEffectText(centerPos, statusEffect, amplifier, deltaX, kDeltaY);
            }
        }
    }

    private double calculateRowWidth(MobEffect statusEffect, int amplifier) {
        double textWidth = RenderUtils.getRenderWidth(BeaconEffectRenderer.getStatusText(statusEffect, amplifier));
        return (double)ICON_RENDERED_SIZE + 5.0 + textWidth;
    }

    private void renderStatusEffectIcon(Vec3 pos, MobEffect statusEffect, int amplifier, double deltaX, double kDeltaY) {
        Minecraft mc = Minecraft.getInstance();
        TextureAtlasSprite sprite = mc.getMobEffectTextures().get(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)statusEffect));
        RenderContext renderContext = RenderContext.of(new PoseStack());
        InWorldPositionTransformer positionTransformer = new InWorldPositionTransformer(pos);
        positionTransformer.apply(renderContext);
        RenderGlobals.disableDepthTest();
        RenderGlobals.enableBlend();
        renderContext.scale(0.025 * (double)RenderUtils.getSizeScalingXSign(), -0.025, 0.025);
        renderContext.translate(deltaX, 0.0, 0.0);
        double k = 1.0 * (double)ICON_RENDERED_SIZE / 18.0;
        renderContext.scale(k, k, k);
        renderContext.translate(0.0, 18.0 * (-0.5 + kDeltaY), 0.0);
        renderContext.getGuiDrawer().blitSprite(RenderType::guiTexturedOverlay, sprite, 0, 0, 18, 18, -1);
        renderContext.getGuiDrawer().flush();
        RenderGlobals.enableDepthTest();
        positionTransformer.restore();
    }

    private void renderStatusEffectText(Vec3 pos, MobEffect statusEffect, int amplifier, double deltaX, double kDeltaY) {
        String description = BeaconEffectRenderer.getStatusText(statusEffect, amplifier);
        TextRenderer textRenderer = TextRenderer.create().at(pos).text(description).fontScale(0.025).align(TextRenderer.HorizontalAlignment.LEFT).seeThrough().shadow();
        textRenderer.shift(deltaX + (double)ICON_RENDERED_SIZE + 5.0, kDeltaY * textRenderer.getLineHeight());
        textRenderer.render();
    }

    private static String getStatusText(MobEffect statusEffect, int amplifier) {
        return StringUtils.translate((String)statusEffect.getDescriptionId(), (Object[])new Object[0]) + " " + StringUtils.translate((String)("enchantment.level." + (amplifier + 1)), (Object[])new Object[0]);
    }
}

