/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.InfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.ScanningCache;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.SimpleCachedWorldView;
import me.fallenbreath.tweakermore.util.PlatformUtils;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.render.RenderUtils;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InfoViewCachedRenderer {
    private long cacheUpdateNs = 0L;
    private CacheData cacheData = null;

    private boolean isCacheInvalid() {
        ClientLevel clientWorld = Minecraft.getInstance().level;
        return clientWorld == null || this.cacheData == null || clientWorld != this.cacheData.clientWorld;
    }

    public void render(RenderContext renderContext, List<InfoViewer> viewers) {
        Minecraft mc = Minecraft.getInstance();
        Level world = WorldUtils.getBestWorld((Minecraft)mc);
        ClientLevel clientWorld = mc.level;
        if (world == null || clientWorld == null || mc.player == null) {
            return;
        }
        Vec3 camPos = mc.player.getEyePosition(RenderUtils.tickDelta);
        Vec3 camVec = mc.player.getLookAngle();
        long now = System.nanoTime();
        long ups = TweakerMoreConfigs.INFO_VIEW_SCANNING_PER_SECOND.getIntegerValue();
        if (this.isCacheInvalid() || ups == 0L || this.cacheUpdateNs == 0L || (double)(now - this.cacheUpdateNs) >= 1.0E9 / (double)ups) {
            this.cacheData = new CacheData(world, (Level)clientWorld);
            this.cacheUpdateNs = now;
            RenderVisitorWorldView worldView = this.cacheData.worldView;
            HashMap renderingPositions = Maps.newHashMap();
            for (InfoViewer viewer : viewers) {
                viewer.scanForRender(this.cacheData.scanningCache, camPos, camVec).forEach((pos, renderer) -> {
                    if (viewer.shouldRenderFor(worldView, (BlockPos)pos)) {
                        if (!worldView.isBestWorldServerWorld() && viewer.requireBlockEntitySyncing(worldView, (BlockPos)pos)) {
                            worldView.syncBlockEntity((BlockPos)pos);
                        }
                        renderingPositions.computeIfAbsent(pos, k -> Lists.newArrayList()).add(renderer);
                    }
                });
            }
            renderingPositions.keySet().stream().map(pos -> Pair.of((Object)pos, (Object)camPos.distanceToSqr(PositionUtils.centerOf(pos)))).sorted(Collections.reverseOrder(Comparator.comparingDouble(Pair::getSecond))).forEach(pair -> {
                BlockPos pos = (BlockPos)pair.getFirst();
                this.cacheData.renderingPositions.put(pos, (List)renderingPositions.get(pos));
            });
        }
        if (TweakerMoreConfigs.TWEAKERMORE_DEBUG_BOOL.getBooleanValue() && PlatformUtils.isDevelopmentEnvironment()) {
            Function<BlockPos, Double> distanceGetter = pos -> camPos.distanceTo(PositionUtils.centerOf(pos));
            Set<BlockPos> positions = this.cacheData.renderingPositions.keySet();
            double maxDis = positions.stream().map(distanceGetter).mapToDouble(x -> x).max().orElse(1.0);
            positions.forEach(pos -> TextRenderer.create().color(0xFFFFFF00 | (int)(255.0 * (Double)distanceGetter.apply((BlockPos)pos) / maxDis)).atCenter((BlockPos)pos).text("x").render());
        }
        this.cacheData.renderingPositions.forEach((pos, renderers) -> {
            for (InfoViewer.Renderer renderer : renderers) {
                renderer.render(renderContext, this.cacheData.worldView, (BlockPos)pos);
            }
        });
    }

    public void onClientTick() {
        this.cacheData = null;
    }

    private static class CacheData {
        private final Level bestWorld;
        private final Level clientWorld;
        private final RenderVisitorWorldView worldView;
        private final ScanningCache scanningCache;
        private final Map<BlockPos, List<InfoViewer.Renderer>> renderingPositions;

        private CacheData(Level bestWorld, Level clientWorld) {
            this.bestWorld = bestWorld;
            this.clientWorld = clientWorld;
            SimpleCachedWorldView cachedBestWorld = new SimpleCachedWorldView(bestWorld);
            SimpleCachedWorldView cachedClientWorld = clientWorld != bestWorld ? new SimpleCachedWorldView(clientWorld) : cachedBestWorld;
            this.worldView = new RenderVisitorWorldView(cachedBestWorld, cachedClientWorld);
            this.scanningCache = new ScanningCache();
            this.renderingPositions = Maps.newLinkedHashMap();
        }
    }
}

