/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint;

import java.util.Optional;
import java.util.function.Predicate;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint.ShulkerBoxItemContentHintRenderer;
import me.fallenbreath.tweakermore.util.IdentifierUtils;
import me.fallenbreath.tweakermore.util.InventoryUtils;
import me.fallenbreath.tweakermore.util.ItemUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ShulkerBoxItemContentHintCommon {
    public static Info prepareInformation(ItemStack itemStack) {
        Optional<ItemStack> override;
        Info info = new Info();
        info.enabled = false;
        if (!TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT.getBooleanValue()) {
            return info;
        }
        if (ShulkerBoxItemContentHintRenderer.isRendering.get().booleanValue()) {
            return info;
        }
        if (!ItemUtils.isShulkerBox(itemStack.getItem())) {
            return info;
        }
        Optional<NonNullList<ItemStack>> stackList = InventoryUtils.getStoredItems(itemStack);
        if (!stackList.isPresent()) {
            return info;
        }
        Predicate<ItemStack> stackFilter = stack -> true;
        if (TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT_CUSTOM_NAMES_OVERRIDE_ITEM.getBooleanValue() && (override = ShulkerBoxItemContentHintCommon.computeCustomNameOverride(itemStack)).isPresent()) {
            stackFilter = stack -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)((ItemStack)override.get()));
        }
        ItemStack std = null;
        info.allItemSame = true;
        info.allItemSameIgnoreNbt = true;
        for (ItemStack stack2 : stackList.get()) {
            if (stack2.isEmpty() || !stackFilter.test(stack2)) continue;
            if (std == null) {
                std = stack2;
                continue;
            }
            boolean itemEqual = ItemStack.isSameItem((ItemStack)stack2, (ItemStack)std);
            boolean itemAndNbtEqual = ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)std);
            if (!itemAndNbtEqual) {
                info.allItemSame = false;
            }
            if (itemEqual) continue;
            info.allItemSameIgnoreNbt = false;
        }
        if (std == null) {
            return info;
        }
        info.stack = std;
        info.scale = TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT_SCALE.getDoubleValue();
        if (info.scale <= 0.0) {
            return info;
        }
        info.enabled = true;
        info.fillRatio = -1.0;
        int slotAmount = InventoryUtils.getInventorySlotAmount(itemStack);
        if (slotAmount != -1) {
            double sum = 0.0;
            for (ItemStack stack3 : stackList.get()) {
                sum += 1.0 * (double)stack3.getCount() / (double)stack3.getMaxStackSize();
            }
            double ratio = sum / (double)slotAmount;
            if (ratio >= 0.0 && ratio <= 1.0) {
                info.fillRatio = ratio;
            }
        }
        return info;
    }

    private static Optional<ItemStack> computeCustomNameOverride(ItemStack shulkerBoxItemStack) {
        if (!shulkerBoxItemStack.has(DataComponents.CUSTOM_NAME)) {
            return Optional.empty();
        }
        Optional<ResourceLocation> itemIdOpt = IdentifierUtils.tryParse(shulkerBoxItemStack.getItemName().getString());
        if (itemIdOpt.isEmpty()) {
            return Optional.empty();
        }
        if (!BuiltInRegistries.ITEM.containsKey(itemIdOpt.get())) {
            return Optional.empty();
        }
        Item item = (Item)BuiltInRegistries.ITEM.getValue(itemIdOpt.get());
        return Optional.of(new ItemStack((ItemLike)item));
    }

    public static class Info {
        public boolean enabled;
        public boolean allItemSame;
        public boolean allItemSameIgnoreNbt;
        public double scale;
        public ItemStack stack;
        public double fillRatio;
    }
}

