/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class InventoryUtils {
    public static int getInventorySlotAmount(ItemStack itemStack) {
        if (itemStack.getItem() instanceof BlockItem) {
            Block block = ((BlockItem)itemStack.getItem()).getBlock();
            if (block instanceof ShulkerBoxBlock || block instanceof ChestBlock || block instanceof BarrelBlock) {
                return 27;
            }
            if (block instanceof AbstractFurnaceBlock) {
                return 3;
            }
            if (block instanceof DispenserBlock) {
                return 9;
            }
            if (block instanceof HopperBlock || block instanceof BrewingStandBlock) {
                return 5;
            }
        }
        return -1;
    }

    public static Optional<NonNullList<ItemStack>> getStoredItems(ItemStack itemStack) {
        int slotAmount = InventoryUtils.getInventorySlotAmount(itemStack);
        if (slotAmount == -1) {
            return Optional.empty();
        }
        return Optional.ofNullable(fi.dy.masa.malilib.util.InventoryUtils.getStoredItems((ItemStack)itemStack, (int)slotAmount));
    }
}

