/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.commandBlock;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import fi.dy.masa.malilib.config.IConfigBoolean;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.mixins.tweaks.features.infoView.commandBlock.CommandSuggestorAccessor;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.TextRenderingUtil;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;

public class CommandBlockContentRenderer
extends CommonScannerInfoViewer {
    public CommandBlockContentRenderer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_COMMAND_BLOCK, TweakerMoreConfigs.INFO_VIEW_COMMAND_BLOCK_RENDER_STRATEGY, TweakerMoreConfigs.INFO_VIEW_COMMAND_BLOCK_TARGET_STRATEGY);
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() instanceof CommandBlock && world.getBlockEntity(pos) instanceof CommandBlockEntity;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, BlockPos pos) {
        return true;
    }

    @Override
    protected void render(RenderContext context, RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof CommandBlockEntity)) {
            return;
        }
        BaseCommandBlock executor = ((CommandBlockEntity)blockEntity).getCommandBlock();
        String command = executor.getCommand();
        Component lastOutput = executor.getLastOutput();
        int MAX_WIDTH = TweakerMoreConfigs.INFO_VIEW_COMMAND_BLOCK_MAX_WIDTH.getIntegerValue();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        StringReader stringReader = new StringReader(command);
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.read();
        }
        ParseResults parse = player.connection.getCommands().parse(stringReader, (Object)player.connection.getSuggestionsProvider());
        String trimmedCommand = TextRenderingUtil.trim(command, MAX_WIDTH);
        FormattedCharSequence displayText = CommandSuggestorAccessor.invokeHighlight((ParseResults<SharedSuggestionProvider>)parse, trimmedCommand, 0);
        if (trimmedCommand.length() < command.length()) {
            displayText = FormattedCharSequence.fromPair((FormattedCharSequence)displayText, (FormattedCharSequence)TextRenderingUtil.string2orderedText(String.valueOf(ChatFormatting.DARK_GRAY) + "..."));
        }
        TextRenderer textRenderer = TextRenderer.create().text(displayText).atCenter(pos).fontScale(0.025 * TweakerMoreConfigs.INFO_VIEW_COMMAND_BLOCK_TEXT_SCALE.getDoubleValue()).bgColor(0x3F000000).shadow().seeThrough();
        if (!lastOutput.getString().isEmpty()) {
            FormattedCharSequence trimmedLastOutput = TextRenderingUtil.trim(lastOutput.getVisualOrderText(), MAX_WIDTH, trimmedText -> FormattedCharSequence.fromPair((FormattedCharSequence)trimmedText, (FormattedCharSequence)TextRenderingUtil.string2orderedText(String.valueOf(ChatFormatting.DARK_GRAY) + "...")));
            textRenderer.addLine(trimmedLastOutput);
        }
        textRenderer.render();
    }
}

