/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.hopper;

import fi.dy.masa.malilib.config.IConfigBoolean;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.mixins.tweaks.features.infoView.hopper.HopperBlockEntityAccessor;
import me.fallenbreath.tweakermore.util.render.ColorHolder;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;

public class HopperCooldownRenderer
extends CommonScannerInfoViewer {
    public HopperCooldownRenderer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_HOPPER, TweakerMoreConfigs.INFO_VIEW_HOPPER_RENDER_STRATEGY, TweakerMoreConfigs.INFO_VIEW_HOPPER_TARGET_STRATEGY);
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() instanceof HopperBlock && world.getBlockEntity(pos) instanceof HopperBlockEntity;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, BlockPos pos) {
        return true;
    }

    @Override
    protected void render(RenderContext context, RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof HopperBlockEntity)) {
            return;
        }
        int cooldown = ((HopperBlockEntityAccessor)blockEntity).getCooldownTime();
        if (cooldown < 0) {
            return;
        }
        double alpha = cooldown > 0 ? 1.0 : 0.2;
        ColorHolder color = ColorHolder.of(204, 204, 204, (int)(255.0 * alpha));
        TextRenderer.create().text(String.valueOf(cooldown)).atCenter(pos).color(color.pack()).shadow().seeThrough().render();
    }
}

