/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.redstoneDust;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fi.dy.masa.malilib.config.IConfigBoolean;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.listentries.InfoViewTargetStrategy;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.RedStoneWireBlock;

public class RedstoneDustUpdateOrderRenderer
extends CommonScannerInfoViewer {
    public RedstoneDustUpdateOrderRenderer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_REDSTONE_DUST_UPDATE_ORDER, TweakerMoreConfigs.INFO_VIEW_REDSTONE_DUST_UPDATE_ORDER_RENDER_STRATEGY, () -> InfoViewTargetStrategy.POINTED);
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() instanceof RedStoneWireBlock;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, BlockPos pos) {
        return false;
    }

    @Override
    protected void render(RenderContext context, RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos) {
        int alphaBits = (int)Math.round(255.0 * TweakerMoreConfigs.INFO_VIEW_REDSTONE_DUST_UPDATE_ORDER_TEXT_ALPHA.getDoubleValue());
        if (alphaBits == 0) {
            return;
        }
        int color = Objects.requireNonNull(ChatFormatting.RED.getColor()) | (alphaBits & 0xFF) << 24;
        List<BlockPos> order = RedstoneDustUpdateOrderRenderer.getDustUpdateOrderAt(pos);
        for (int i = 0; i < order.size(); ++i) {
            this.renderTextAtPos(context, order.get(i), String.valueOf(i + 1), color);
        }
    }

    private void renderTextAtPos(RenderContext context, BlockPos pos, String text, int color) {
        TextRenderer.create().text(text).atCenter(pos).color(color).shadow().seeThrough().render();
    }

    private static List<BlockPos> getDustUpdateOrderAt(BlockPos pos) {
        HashSet set = Sets.newHashSet();
        set.add(pos);
        for (Direction direction : Direction.values()) {
            set.add(pos.relative(direction));
        }
        return Lists.newArrayList((Iterable)set);
    }
}

