/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict;

import fi.dy.masa.malilib.util.LayerRange;
import java.util.Objects;
import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace.BlockItemAccessor;
import me.fallenbreath.tweakermore.util.IdentifierUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;

class RestrictionUtils {
    RestrictionUtils() {
    }

    public static boolean isItemInRestrictorWhitelist(ItemStack itemStack) {
        return TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_ITEM_WHITELIST.getStrings().stream().map(IdentifierUtils::tryParseOrNull).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).anyMatch(item -> Objects.equals(item, itemStack.getItem()));
    }

    public static boolean isWithinLayerRange(LayerRange layerRange, BlockPos pos, int margin) {
        return layerRange.intersectsBox(pos.offset(-margin, -margin, -margin), pos.offset(margin, margin, margin));
    }

    public static ItemStack getPlayerUsingStack(Player player) {
        ItemStack stackToUse = player.getMainHandItem();
        if (stackToUse.isEmpty()) {
            stackToUse = player.getOffhandItem();
        }
        return stackToUse;
    }

    public static Optional<BlockState> getStateToPlace(BlockPlaceContext context, ItemStack stackToUse) {
        BlockItem blockItem;
        BlockPlaceContext ctx;
        Item item = stackToUse.getItem();
        if (item instanceof BlockItem && (ctx = (blockItem = (BlockItem)item).updatePlacementContext(context)) != null) {
            return Optional.ofNullable(((BlockItemAccessor)blockItem).invokeGetPlacementState(ctx));
        }
        return Optional.empty();
    }
}

