/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.features.fireworkRocketThrottler;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import fi.dy.masa.malilib.util.InfoUtils;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Unique
    private long lastFireworkRocketUsageMilli = 0L;
    @Unique
    private final ThreadLocal<Boolean> nullPacketSkipping = ThreadLocal.withInitial(() -> false);

    @Inject(method={"lambda$useItemOn$4"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireworkRocketThrottler_cancelIfCooldown_useOnBlock(CallbackInfoReturnable<Packet<?>> cir, @Local(argsOnly=true) LocalPlayer player, @Local(argsOnly=true) InteractionHand hand, @Local(argsOnly=true) MutableObject<InteractionResult> actionResult) {
        if (this.checkCooldown((Player)player, hand)) {
            this.nullPacketSkipping.set(true);
            cir.setReturnValue(null);
            actionResult.setValue((Object)InteractionResult.FAIL);
        }
    }

    @Inject(method={"lambda$useItem$5"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireworkRocketThrottler_cancelIfCooldown_useAtAir(CallbackInfoReturnable<Packet<?>> cir, @Local(argsOnly=true) Player player, @Local(argsOnly=true) InteractionHand hand, @Local(argsOnly=true) MutableObject<InteractionResult> actionResult) {
        if (this.checkCooldown(player, hand)) {
            this.nullPacketSkipping.set(true);
            cir.setReturnValue(null);
            actionResult.setValue((Object)InteractionResult.FAIL);
        }
    }

    @Unique
    private boolean checkCooldown(Player player, InteractionHand hand) {
        ItemStack itemStack;
        if (TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER.getBooleanValue() && (itemStack = player.getItemInHand(hand)).getItem() instanceof FireworkRocketItem) {
            long now = System.currentTimeMillis();
            double cooldown = TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER_COOLDOWN.getDoubleValue();
            double remaining = cooldown - (double)(now - this.lastFireworkRocketUsageMilli) / 1000.0;
            if (remaining > 0.0) {
                InfoUtils.printActionbarMessage((String)"tweakermore.impl.fireworkRocketThrottler.throttled", (Object[])new Object[]{String.format("%.1f", remaining)});
                return true;
            }
        }
        return false;
    }

    @Inject(method={"startPrediction"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;predict(I)Lnet/minecraft/network/protocol/Packet;", shift=At.Shift.AFTER)}, cancellable=true)
    private void fireworkRocketThrottler_cancelSendSequencedPacketIfNull(CallbackInfo ci) {
        if (this.nullPacketSkipping.get().booleanValue()) {
            this.nullPacketSkipping.remove();
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"performUseItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult fireworkRocketThrottler_updateCooldown_useOnBlock(InteractionResult actionResult) {
        this.updateCooldownOnUse(actionResult);
        return actionResult;
    }

    @ModifyExpressionValue(method={"lambda$useItem$5"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/common/CommonHooks;onItemRightClick(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult fireworkRocketThrottler_updateCooldown_useAtAir(InteractionResult actionResult) {
        this.updateCooldownOnUse(actionResult);
        return actionResult;
    }

    @Unique
    private void updateCooldownOnUse(InteractionResult actionResult) {
        if (TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER.getBooleanValue() && actionResult.consumesAction()) {
            this.lastFireworkRocketUsageMilli = System.currentTimeMillis();
        }
    }
}

