/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;

public class PositionUtils {
    public static BlockPos floored(Vec3 vec3d) {
        return BlockPos.containing((Position)vec3d);
    }

    public static Vec3 centerOf(BlockPos blockPos) {
        return new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
    }

    public static Collection<BlockPos> boxSurface(BlockPos pos1, BlockPos pos2) {
        int z;
        int x;
        int minX = Math.min(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        LongOpenHashSet set = new LongOpenHashSet();
        ArrayList result = Lists.newArrayList();
        Consumer<BlockPos> storage = pos -> {
            if (set.add(pos.asLong())) {
                result.add(pos);
            }
        };
        for (x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                storage.accept(new BlockPos(x, y, minZ));
                storage.accept(new BlockPos(x, y, maxZ));
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                storage.accept(new BlockPos(x, minY, z));
                storage.accept(new BlockPos(x, maxY, z));
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (z = minZ; z <= maxZ; ++z) {
                storage.accept(new BlockPos(minX, y, z));
                storage.accept(new BlockPos(maxX, y, z));
            }
        }
        return result;
    }

    public static Collection<BlockPos> beam(Vec3 startPos, Vec3 endPos, double coneAngle, BeamMode mode) {
        Vec3 dir1 = endPos.subtract(startPos).normalize();
        if (dir1 == Vec3.ZERO) {
            return Collections.emptyList();
        }
        double maxLen = startPos.distanceTo(endPos);
        double step = 1.0 / (1.0 + Math.sin(coneAngle));
        Long2DoubleOpenHashMap positions = new Long2DoubleOpenHashMap();
        BlockPos lastMin = null;
        BlockPos lastMax = null;
        double angle = coneAngle;
        block4: for (double len = 0.0; len < maxLen + step; len += step) {
            double r = len * Math.sin(angle);
            Vec3 vec3d = startPos.add(dir1.scale(len));
            Vec3 a2 = vec3d.add(-r, -r, -r);
            Vec3 b = vec3d.add(r, r, r);
            BlockPos pos1 = new BlockPos((int)Math.floor(a2.x), (int)Math.floor(a2.y), (int)Math.floor(a2.z));
            BlockPos pos2 = new BlockPos((int)Math.ceil(b.x), (int)Math.ceil(b.y), (int)Math.ceil(b.z));
            if (lastMin != null) {
                int y;
                int x;
                int z;
                int y2;
                int minX = pos1.getX();
                int minY = pos1.getY();
                int minZ = pos1.getZ();
                int maxX = pos2.getX();
                int maxY = pos2.getY();
                int maxZ = pos2.getZ();
                if (minX != lastMin.getX()) {
                    for (y2 = minY; y2 <= maxY; ++y2) {
                        for (z = minZ; z <= maxZ; ++z) {
                            positions.putIfAbsent(new BlockPos(minX, y2, z).asLong(), angle);
                        }
                    }
                }
                if (maxX != lastMax.getX()) {
                    for (y2 = minY; y2 <= maxY; ++y2) {
                        for (z = minZ; z <= maxZ; ++z) {
                            positions.putIfAbsent(new BlockPos(maxX, y2, z).asLong(), angle);
                        }
                    }
                }
                if (minY != lastMin.getY()) {
                    for (x = minX; x <= maxX; ++x) {
                        for (z = minZ; z <= maxZ; ++z) {
                            positions.putIfAbsent(new BlockPos(x, minY, z).asLong(), angle);
                        }
                    }
                }
                if (maxY != lastMax.getY()) {
                    for (x = minX; x <= maxX; ++x) {
                        for (z = minZ; z <= maxZ; ++z) {
                            positions.putIfAbsent(new BlockPos(x, maxY, z).asLong(), angle);
                        }
                    }
                }
                if (minZ != lastMin.getZ()) {
                    for (x = minX; x <= maxX; ++x) {
                        for (y = minY; y <= maxY; ++y) {
                            positions.putIfAbsent(new BlockPos(x, y, minZ).asLong(), angle);
                        }
                    }
                }
                if (maxZ != lastMin.getZ()) {
                    for (x = minX; x <= maxX; ++x) {
                        for (y = minY; y <= maxY; ++y) {
                            positions.putIfAbsent(new BlockPos(x, y, maxZ).asLong(), angle);
                        }
                    }
                }
            } else {
                for (BlockPos pos : PositionUtils.boxSurface(pos1, pos2)) {
                    positions.putIfAbsent(pos.asLong(), angle);
                }
            }
            lastMin = pos1;
            lastMax = pos2;
            switch (mode.ordinal()) {
                case 0: {
                    angle = coneAngle * Math.max(1.0 - len / maxLen, 0.0);
                    continue block4;
                }
                case 1: {
                    angle = coneAngle;
                }
            }
        }
        ArrayList result = Lists.newArrayList();
        positions.forEach((l, a) -> {
            Vec3 dir2;
            double cos;
            BlockPos pos = BlockPos.of((long)l);
            Vec3 vec3d = PositionUtils.centerOf(pos).subtract(startPos);
            if (vec3d.length() <= maxLen && (cos = (dir2 = vec3d.normalize()).dot(dir1)) >= Math.cos(a)) {
                result.add(pos);
            }
        });
        return result;
    }

    public static enum BeamMode {
        BEAM,
        CONE;

    }
}

