/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.compat.carpet;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.util.PlatformUtils;
import me.fallenbreath.tweakermore.util.ReflectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class CarpetModAccess {
    private static final List<Supplier<Optional<Boolean>>> TICK_FROZEN_FLAG_GETTERS = Lists.newArrayList((Object[])new Supplier[]{CarpetModAccess::getIsTickFrozenOld, CarpetModAccess::getIsTickFrozenNew});

    private static boolean checkCarpetVersion(String predicate) {
        if (!PlatformUtils.isModLoaded("bedsheet")) {
            return false;
        }
        if (ModList.get() == null) {
            ArtifactVersion version2 = LoadingModList.get().getModFileById("bedsheet").getFile().getJarVersion();
            return PlatformUtils.doesVersionSatisfyPredicate(version2, predicate);
        }
        return ModList.get().getModContainerById("bedsheet").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(version -> PlatformUtils.doesVersionSatisfyPredicate(version, predicate)).orElse(false);
    }

    private static Optional<Boolean> getIsTickFrozenOld() {
        if (!CarpetModAccess.checkCarpetVersion("<1.4.108")) {
            return Optional.empty();
        }
        Optional<Class<?>> tickSpeedOpt = ReflectionUtils.getClass("carpet.helpers.TickSpeed");
        if (!tickSpeedOpt.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to get field carpet.helpers.TickSpeed: {}", tickSpeedOpt);
            return Optional.empty();
        }
        Class<?> tickSpeedClass = tickSpeedOpt.get();
        ReflectionUtils.ValueWrapper flagWrapper = ReflectionUtils.getStaticField(tickSpeedClass, "process_entities");
        if (!flagWrapper.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to get field carpet.helpers.TickSpeed#process_entities: {}", flagWrapper);
            return Optional.empty();
        }
        return Optional.of((Boolean)flagWrapper.get() == false);
    }

    private static Optional<Boolean> getIsTickFrozenNew() {
        if (!CarpetModAccess.checkCarpetVersion(">=1.4.108")) {
            return Optional.empty();
        }
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return Optional.of(false);
        }
        ReflectionUtils.ValueWrapper trmWrapper = ReflectionUtils.invoke(world.getClass(), "tickRateManager", world, new Object[0]);
        if (!trmWrapper.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to invoked carpet.fakes.LevelInterface#tickRateManager() from a ClientWorld: {}", trmWrapper);
            return Optional.empty();
        }
        Object trm = trmWrapper.get();
        ReflectionUtils.ValueWrapper runsNormally = ReflectionUtils.invoke(trm.getClass(), "runsNormally", trm, new Object[0]);
        if (!runsNormally.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to invoked carpet.helpers.TickRateManager#runsNormally(): {}", runsNormally);
            return Optional.empty();
        }
        return Optional.of((Boolean)runsNormally.get() == false);
    }

    public static boolean isTickFrozen() {
        for (Supplier<Optional<Boolean>> flagGetter : TICK_FROZEN_FLAG_GETTERS) {
            Optional<Boolean> frozen = flagGetter.get();
            if (!frozen.isPresent()) continue;
            return frozen.get();
        }
        return false;
    }
}

