/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.doc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.util.PlatformUtils;
import me.fallenbreath.tweakermore.util.doc.DocumentPrinter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;

public class DocumentGenerator {
    private static CompletableFuture<Void> completableFuture = null;
    private static final List<String> LANGS = ImmutableList.of((Object)"en_us", (Object)"zh_cn");

    private static CompletableFuture<Void> setLanguage(String lang) {
        TweakerMoreMod.LOGGER.info("Setting client language to {}", (Object)lang);
        LanguageManager languageManager = Minecraft.getInstance().getLanguageManager();
        LanguageInfo languageDefinition = languageManager.getLanguage(lang);
        if (languageDefinition != languageManager.getLanguage(languageManager.getSelected())) {
            languageManager.setSelected(lang);
            return Minecraft.getInstance().reloadResourcePacks();
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private static CompletableFuture<Void> generateDoc(String lang) {
        return DocumentGenerator.setLanguage(lang).thenRun(() -> DocumentPrinter.printDoc(lang));
    }

    private static void generateDoc(boolean exit) {
        if (completableFuture == null) {
            int i;
            completableFuture = new CompletableFuture();
            TweakerMoreMod.LOGGER.info("Generating doc...");
            String prevLang = Minecraft.getInstance().options.languageCode;
            CompletableFuture[] futures = new CompletableFuture[LANGS.size() + 1];
            for (i = 0; i < futures.length; ++i) {
                futures[i] = new CompletableFuture();
            }
            for (i = 0; i < LANGS.size(); ++i) {
                int finalI = i;
                futures[i].thenRun(() -> DocumentGenerator.generateDoc(LANGS.get(finalI)).thenRun(() -> futures[finalI + 1].complete(null)));
            }
            futures[LANGS.size()].thenRun(() -> {
                TweakerMoreMod.LOGGER.info("Restoring language back to {}", (Object)prevLang);
                DocumentGenerator.setLanguage(prevLang).thenRun(() -> {
                    completableFuture.complete(null);
                    completableFuture = null;
                    TweakerMoreMod.LOGGER.info("Doc generating done");
                    if (exit) {
                        TweakerMoreMod.LOGGER.info("Stopping Minecraft client");
                        Minecraft.getInstance().stop();
                    }
                });
            });
            futures[0].complete(null);
        }
    }

    public static void onHotKey() {
        DocumentGenerator.generateDoc(false);
    }

    public static void onClientInitFinished() {
        if (PlatformUtils.isDevelopmentEnvironment() && "true".equals(System.getProperty("tweakermore.gen_doc"))) {
            TweakerMoreMod.LOGGER.info("Starting Tweakermore automatic doc generating");
            DocumentGenerator.generateDoc(true);
        }
    }
}

