/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.render;

import java.util.Objects;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class InWorldPositionTransformer {
    private final Vec3 pos;
    private RenderContext renderContext;

    public InWorldPositionTransformer(Vec3 pos) {
        this.pos = pos;
        this.renderContext = null;
    }

    public void apply(RenderContext renderContext) {
        this.renderContext = renderContext;
        Minecraft client = Minecraft.getInstance();
        Camera camera = client.gameRenderer.getMainCamera();
        Vec3 vec3d = this.pos.subtract(camera.getPosition());
        renderContext.pushMatrix();
        renderContext.translate(vec3d.x, vec3d.y, vec3d.z);
        renderContext.multMatrix(new Matrix4f().rotation((Quaternionfc)camera.rotation()));
    }

    public void restore() {
        Objects.requireNonNull(this.renderContext);
        this.renderContext.popMatrix();
        this.renderContext = null;
    }
}

