/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.render;

import com.google.common.collect.Lists;
import fi.dy.masa.malilib.event.RenderEventHandler;
import fi.dy.masa.malilib.interfaces.IRenderer;
import java.util.List;
import me.fallenbreath.tweakermore.util.render.TweakerMoreIRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import me.fallenbreath.tweakermore.util.render.context.WorldRenderContextImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.profiling.ProfilerFiller;
import org.joml.Matrix4fStack;

public abstract class TweakerMoreRenderEventHandler {
    private static final List<TweakerMoreIRenderer> renderers = Lists.newArrayList();

    public static void register(TweakerMoreIRenderer renderer) {
        renderers.add(renderer);
    }

    public static void init() {
        RenderEventHandler.getInstance().registerGameOverlayRenderer((IRenderer)new MalilibRendererHook());
    }

    public static void dispatchRenderWorldPostEvent(Minecraft mc, Matrix4fStack matrixStack) {
        ProfilerFiller profiler = mc.getProfiler();
        profiler.pop();
        profiler.push("TweakerMore_WorldRenderPostHook");
        WorldRenderContextImpl renderContext = RenderContext.createWorldRenderContext(matrixStack);
        renderers.forEach(renderer -> renderer.onRenderWorldLast(renderContext));
        profiler.pop();
    }

    private static void dispatchRenderGameOverlayPost(RenderContext renderContext) {
        renderers.forEach(renderer -> renderer.onRenderGameOverlayPost(renderContext));
    }

    private static class MalilibRendererHook
    implements IRenderer {
        private MalilibRendererHook() {
        }

        public void onRenderGameOverlayPost(GuiGraphics matrixStackOrDrawContext) {
            TweakerMoreRenderEventHandler.dispatchRenderGameOverlayPost(RenderContext.of(matrixStackOrDrawContext));
        }
    }
}

