/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.structureBlock;

import fi.dy.masa.malilib.config.IConfigBoolean;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.mixins.tweaks.features.infoView.structureBlock.StructureBlockScreenAccessor;
import me.fallenbreath.tweakermore.util.Messenger;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.TextRenderingUtil;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;

public class StructureBlockContentRenderer
extends CommonScannerInfoViewer {
    public StructureBlockContentRenderer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_STRUCTURE_BLOCK, TweakerMoreConfigs.INFO_VIEW_STRUCTURE_BLOCK_RENDER_STRATEGY, TweakerMoreConfigs.INFO_VIEW_STRUCTURE_BLOCK_TARGET_STRATEGY);
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() instanceof StructureBlock;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, BlockPos pos) {
        Screen currentScreen = Minecraft.getInstance().screen;
        return !(currentScreen instanceof StructureBlockScreenAccessor) || !pos.equals((Object)((StructureBlockScreenAccessor)currentScreen).getStructureBlock().getBlockPos());
    }

    @Override
    protected void render(RenderContext context, RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof StructureBlockEntity)) {
            return;
        }
        StructureBlockEntity sbe = (StructureBlockEntity)blockEntity;
        String structureName = sbe.getStructureName();
        MutableComponent nameText = null;
        if (!structureName.isEmpty()) {
            String trimmedName = TextRenderingUtil.trim(structureName, TweakerMoreConfigs.INFO_VIEW_STRUCTURE_BLOCK_MAX_WIDTH.getIntegerValue());
            String[] parts = trimmedName.split(":", 2);
            if (parts.length == 2) {
                String ns = parts[0];
                String path = parts[1];
                ChatFormatting nsColor = ns.equals("minecraft") ? ChatFormatting.GRAY : ChatFormatting.YELLOW;
                nameText = Messenger.c(Messenger.s(ns, nsColor), Messenger.s(":", ChatFormatting.GRAY), Messenger.s(path, ChatFormatting.AQUA));
            } else {
                nameText = Messenger.s(trimmedName, ChatFormatting.AQUA);
            }
            if (trimmedName.length() < structureName.length()) {
                nameText = Messenger.c(nameText, Messenger.s("...", ChatFormatting.DARK_GRAY));
            }
        }
        TextRenderer textRenderer = TextRenderer.create().atCenter(pos).fontScale(0.025 * TweakerMoreConfigs.INFO_VIEW_STRUCTURE_BLOCK_TEXT_SCALE.getDoubleValue()).bgColor(0x3F000000).shadow().seeThrough();
        textRenderer.addLine((Component)Messenger.c(Messenger.s("["), Messenger.tr("structure_block.mode." + sbe.getMode().getSerializedName(), new Object[0]), Messenger.s("]")));
        if (nameText != null) {
            textRenderer.addLine((Component)nameText);
        }
        textRenderer.render();
    }
}

