/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.pistorder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.pistorder.DisplayMode;
import me.fallenbreath.tweakermore.impl.features.pistorder.ImmovableBlockPosRecorder;
import me.fallenbreath.tweakermore.impl.features.pistorder.PistonActionType;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.PushLimitManager;
import me.fallenbreath.tweakermore.mixins.tweaks.features.pistorder.PistonBlockAccessor;
import me.fallenbreath.tweakermore.util.Messenger;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.TemporaryBlockReplacer;
import me.fallenbreath.tweakermore.util.render.ColorHolder;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PistorderDisplay {
    private static final String INDICATOR_SUCCESS = String.valueOf(ChatFormatting.GREEN) + "\u221a";
    private static final String INDICATOR_FAIL = String.valueOf(ChatFormatting.RED) + "\u00d7";
    private List<BlockPos> movedBlocks;
    private List<BlockPos> brokenBlocks;
    private boolean moveSuccess;
    @Nullable
    private BlockPos immovableBlockPos;
    public final Level world;
    public final BlockPos pistonPos;
    public final BlockState blockState;
    public final Direction direction;
    public PistonActionType actionType;
    public final int color;
    private DisplayMode displayMode;
    private long lastUpdateTime = -1L;

    public PistorderDisplay(Level world, BlockPos pistonPos, BlockState blockState, Direction direction, PistonActionType actionType) {
        this.world = world;
        this.pistonPos = pistonPos;
        this.blockState = blockState;
        this.direction = direction;
        this.actionType = actionType;
        this.setDisplayMode(DisplayMode.DIRECT);
        Random random = new Random(pistonPos.hashCode());
        this.color = random.nextInt(80) + 175 + (random.nextInt(80) + 175 << 8) + (random.nextInt(80) + 175 << 16);
    }

    private Direction getPistonFacing() {
        return (Direction)this.blockState.getValue((Property)PistonBaseBlock.FACING);
    }

    private boolean isStickyPiston() {
        return ((PistonBlockAccessor)this.blockState.getBlock()).getIsSticky();
    }

    public boolean isDisabled() {
        return this.displayMode == DisplayMode.DISABLED;
    }

    private void disable() {
        this.displayMode = DisplayMode.DISABLED;
    }

    private void setDisplayMode(DisplayMode mode) {
        this.displayMode = mode;
        this.refreshInformation();
    }

    private void refreshInformation() {
        BlockPos simulatedPistonPos = null;
        switch (this.displayMode) {
            case DIRECT: {
                simulatedPistonPos = this.pistonPos;
                break;
            }
            case INDIRECT: {
                simulatedPistonPos = this.pistonPos;
                if (this.isStickyPiston()) break;
                simulatedPistonPos = simulatedPistonPos.offset(this.getPistonFacing().getNormal());
                break;
            }
        }
        if (simulatedPistonPos != null) {
            this.analyze(this.world, simulatedPistonPos, this.getPistonFacing(), this.actionType);
        }
    }

    private void analyze(Level world, BlockPos simulatedPistonPos, Direction pistonFacing, PistonActionType PistonActionType2) {
        BlockState air = Blocks.AIR.defaultBlockState();
        TemporaryBlockReplacer blockReplacer = new TemporaryBlockReplacer(this.world);
        if (!this.pistonPos.equals((Object)simulatedPistonPos)) {
            blockReplacer.add(this.pistonPos, air);
        }
        if (PistonActionType2.isRetract()) {
            blockReplacer.add(simulatedPistonPos.offset(pistonFacing.getNormal()), air);
        }
        blockReplacer.removeBlocks();
        PistonStructureResolver pistonHandler = new PistonStructureResolver(world, simulatedPistonPos, pistonFacing, PistonActionType2.isPush());
        this.moveSuccess = pistonHandler.resolve();
        if (!this.moveSuccess) {
            int newPushLimit = Math.max(PushLimitManager.getInstance().getPushLimit(), TweakerMoreConfigs.PISTORDER_MAX_SIMULATION_PUSH_LIMIT.getIntegerValue());
            PushLimitManager.getInstance().overwritePushLimit(newPushLimit);
            pistonHandler.resolve();
        }
        blockReplacer.restoreBlocks();
        PushLimitManager.getInstance().restorePushLimit();
        this.brokenBlocks = Lists.newArrayList((Iterable)pistonHandler.getToDestroy());
        this.movedBlocks = Lists.newArrayList((Iterable)pistonHandler.getToPush());
        this.immovableBlockPos = ((ImmovableBlockPosRecorder)pistonHandler).getImmovableBlockPos$TKM();
        Collections.reverse(this.brokenBlocks);
        Collections.reverse(this.movedBlocks);
    }

    private boolean tryIndirectMode() {
        BlockState blockInFront1 = this.world.getBlockState(this.pistonPos.relative(this.getPistonFacing(), 1));
        BlockState blockInFront2 = this.world.getBlockState(this.pistonPos.relative(this.getPistonFacing(), 2));
        if (blockInFront1.isAir() && !blockInFront2.isAir()) {
            if (this.isStickyPiston()) {
                this.actionType = PistonActionType.RETRACT;
            }
            this.setDisplayMode(DisplayMode.INDIRECT);
            return true;
        }
        return false;
    }

    public void onClick() {
        switch (this.displayMode) {
            case DIRECT: {
                if (this.tryIndirectMode()) break;
                this.disable();
                break;
            }
            case INDIRECT: {
                this.disable();
                break;
            }
        }
    }

    private static TextRenderer drawString(BlockPos pos, float offsetY, Component text, int color) {
        ColorHolder colorHolder = ColorHolder.of(color).modify(h -> {
            h.alpha = (int)(255.0 * TweakerMoreConfigs.PISTORDER_TEXT_ALPHA.getDoubleValue());
        });
        TextRenderer renderer = TextRenderer.create().at(PositionUtils.centerOf(pos)).text(text).color(colorHolder.pack()).fontScale(0.025 * TweakerMoreConfigs.PISTORDER_TEXT_SCALE.getDoubleValue()).seeThrough().shadow(TweakerMoreConfigs.PISTORDER_TEXT_SHADOW.getBooleanValue());
        renderer.shift(0.0, (double)offsetY * renderer.getLineHeight());
        return renderer;
    }

    private boolean checkState(Level world) {
        if (!Objects.equals(world, this.world)) {
            return false;
        }
        LevelChunk chunk = world.getChunkSource().getChunkNow(this.pistonPos.getX() >> 4, this.pistonPos.getZ() >> 4);
        if (chunk instanceof LevelChunk && !chunk.isEmpty()) {
            return chunk.getBlockState(this.pistonPos).equals(this.blockState);
        }
        return true;
    }

    public List<@NotNull TextRenderer> render() {
        ArrayList texts = Lists.newArrayList();
        if (!this.isDisabled()) {
            int i;
            Minecraft client = Minecraft.getInstance();
            if (!this.checkState((Level)client.level)) {
                this.disable();
                return Collections.emptyList();
            }
            String actionKey = this.actionType.isPush() ? "tweakermore.impl.pistorder.push" : "tweakermore.impl.pistorder.retract";
            String actionResult = this.moveSuccess ? INDICATOR_SUCCESS : INDICATOR_FAIL;
            texts.add(PistorderDisplay.drawString(this.pistonPos, -0.5f, (Component)Messenger.s(String.format("%s %s", I18n.get((String)actionKey, (Object[])new Object[0]), actionResult), ChatFormatting.GOLD), this.color));
            texts.add(PistorderDisplay.drawString(this.pistonPos, 0.5f, (Component)Messenger.c(Messenger.formatting(Messenger.tr("tweakermore.impl.pistorder.block_count.pre", new Object[0]), ChatFormatting.GOLD), Messenger.s(this.movedBlocks.size()), Messenger.formatting(Messenger.tr("tweakermore.impl.pistorder.block_count.post", new Object[0]), ChatFormatting.GOLD)), this.color));
            for (i = 0; i < this.movedBlocks.size(); ++i) {
                texts.add(PistorderDisplay.drawString(this.movedBlocks.get(i), 0.0f, (Component)Messenger.s(i + 1), this.color));
            }
            for (i = 0; i < this.brokenBlocks.size(); ++i) {
                texts.add(PistorderDisplay.drawString(this.brokenBlocks.get(i), 0.0f, (Component)Messenger.s(i + 1), ChatFormatting.RED.getColor()));
            }
            if (this.immovableBlockPos != null) {
                texts.add(PistorderDisplay.drawString(this.immovableBlockPos, 0.0f, (Component)Messenger.s("\u00d7"), ChatFormatting.DARK_RED.getColor()));
            }
        }
        return texts.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void tick() {
        if (TweakerMoreConfigs.PISTORDER_DYNAMICALLY_INFO_UPDATE.getBooleanValue() && this.world.getGameTime() != this.lastUpdateTime) {
            this.refreshInformation();
            this.lastUpdateTime = this.world.getGameTime();
        }
    }
}

