/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit;

import com.google.common.collect.Lists;
import java.util.List;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers.ForgeCarpetHandler;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers.PushLimitHandler;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers.PushLimitOperateException;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers.QuickCarpetHandler;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers.VanillaHandler;
import me.fallenbreath.tweakermore.util.PlatformUtils;

public class PushLimitManager {
    private static final PushLimitManager INSTANCE = new PushLimitManager();
    private Integer oldPushLimit = null;
    private final List<PushLimitHandler> handlers = Lists.newArrayList();

    private PushLimitManager() {
        this.handlers.add(new QuickCarpetHandler());
        this.handlers.add(new ForgeCarpetHandler());
        this.handlers.add(new VanillaHandler());
    }

    public static PushLimitManager getInstance() {
        return INSTANCE;
    }

    public boolean shouldLoadPistorderPushLimitMixin() {
        for (PushLimitHandler handler : this.handlers) {
            String modId = handler.getModId();
            if (modId == null || !PlatformUtils.isModLoaded(modId)) continue;
            return false;
        }
        return true;
    }

    public int getPushLimit() {
        for (PushLimitHandler handler : this.handlers) {
            try {
                return handler.getPushLimit();
            }
            catch (PushLimitOperateException pushLimitOperateException) {
            }
        }
        throw new IllegalStateException("getPushLimit failed");
    }

    private void setPushLimit(int pushLimit) {
        for (PushLimitHandler handler : this.handlers) {
            try {
                handler.setPushLimit(pushLimit);
                return;
            }
            catch (PushLimitOperateException pushLimitOperateException) {
            }
        }
        throw new IllegalStateException("setPushLimit failed");
    }

    public void overwritePushLimit(int pushLimit) {
        this.oldPushLimit = this.getPushLimit();
        this.setPushLimit(pushLimit);
    }

    public void restorePushLimit() {
        if (this.oldPushLimit != null) {
            this.setPushLimit(this.oldPushLimit);
            this.oldPushLimit = null;
        }
    }
}

