/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.litematica.config.Configs;
import java.util.List;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.TweakerMoreConfigBooleanHotkeyed;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.SchematicBlockPicker;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.PlacementRestrictor;
import me.fallenbreath.tweakermore.util.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ProPlaceImpl {
    private static final List<TweakerMoreConfigBooleanHotkeyed> PRO_PLACE_CONFIGS = Lists.newArrayList((Object[])new TweakerMoreConfigBooleanHotkeyed[]{TweakerMoreConfigs.AUTO_PICK_SCHEMATIC_BLOCK, TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION});

    public static String modifyComment(String comment) {
        String lines = StringUtils.configsToListLines(PRO_PLACE_CONFIGS);
        return comment.replaceFirst("##CONFIGS##", lines);
    }

    public static void handleRightClick(PlacementContextProvider contextProvider, CallbackInfoReturnable<InteractionResult> cir) {
        Pair<BlockHitResult, BlockPlaceContext> pair;
        boolean restrict;
        if (Configs.Generic.EASY_PLACE_MODE.getBooleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        boolean proPlace = TweakerMoreConfigs.SCHEMATIC_PRO_PLACE.getBooleanValue();
        boolean autoPick = proPlace || TweakerMoreConfigs.AUTO_PICK_SCHEMATIC_BLOCK.getBooleanValue();
        boolean bl = restrict = proPlace || TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION.getBooleanValue();
        if (autoPick) {
            BlockPlaceContext ctx = (BlockPlaceContext)contextProvider.provide().getSecond();
            SchematicBlockPicker.doSchematicWorldPickBlock(mc, ctx.getClickedPos(), ctx.getHand());
        }
        if (restrict && !PlacementRestrictor.canDoBlockPlacement(mc, (BlockHitResult)(pair = contextProvider.provide()).getFirst(), (BlockPlaceContext)pair.getSecond())) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @FunctionalInterface
    public static interface PlacementContextProvider {
        public Pair<BlockHitResult, BlockPlaceContext> provide();
    }
}

