/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.ProPlaceUtils;
import me.fallenbreath.tweakermore.util.EntityUtils;
import me.fallenbreath.tweakermore.util.PlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SchematicBlockPicker {
    private static final boolean TWEAKEROO_LOADED = PlatformUtils.isModLoaded("tweakerge");

    public static void doSchematicWorldPickBlock(Minecraft mc, BlockPos pos, InteractionHand hand) {
        if (!Configs.Visuals.ENABLE_RENDERING.getBooleanValue() || !Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            return;
        }
        WorldSchematic schematicWorld = SchematicWorldHandler.getSchematicWorld();
        ClientLevel clientWorld = mc.level;
        if (schematicWorld != null && mc.player != null && clientWorld != null && mc.gameMode != null) {
            LayerRange layerRange = DataManager.getRenderLayerRange();
            if (!layerRange.isPositionWithinRange(pos)) {
                return;
            }
            BlockState state = schematicWorld.getBlockState(pos);
            ItemStack stack = ProPlaceUtils.getItemForState(state, (Level)schematicWorld, pos);
            InventoryUtils.schematicWorldPickBlock((ItemStack)stack, (BlockPos)pos, (Level)schematicWorld, (Minecraft)mc);
            if (!stack.isEmpty()) {
                // empty if block
            }
            SchematicBlockPicker.fixTweakerooHandRestoreState(hand);
        }
    }

    private static void fixTweakerooHandRestoreState(InteractionHand hand) {
        if (EntityUtils.TWEAKEROO_LOADED) {
            PlacementTweaks.cacheStackInHand((InteractionHand)hand);
        }
    }
}

