/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.InteractAbleTester;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.InteractAllowedTester;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.InteractAllowedTesters;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInteractionRestrictor {
    private static final Map<Class<? extends Block>, InteractAbleTester> INTERACT_ABLE_TESTER_MAP = Maps.newHashMap();
    private static final Map<Class<? extends Block>, InteractAllowedTester> INTERACT_ALLOWED_TESTER_MAP = Maps.newHashMap();

    private static RequirementBuilder interactAble(Class<? extends Block> blockClass) {
        return new RequirementBuilder(blockClass);
    }

    public static Result checkInteract(Player player, BlockState worldState, BlockState schematicState) {
        boolean shiftingAndHasItem;
        boolean hasItemOnHand = !player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty();
        boolean bl = shiftingAndHasItem = player.isShiftKeyDown() && hasItemOnHand;
        if (shiftingAndHasItem) {
            return Result.no();
        }
        boolean canConsume = false;
        for (Class<?> clazz = worldState.getBlock().getClass(); clazz != null && clazz != Block.class; clazz = clazz.getSuperclass()) {
            Optional<String> failureMessage;
            InteractAbleTester tester1 = INTERACT_ABLE_TESTER_MAP.get(clazz);
            if (tester1 == null || !tester1.isInteractAble(player, worldState)) continue;
            canConsume = true;
            InteractAllowedTester tester2 = INTERACT_ALLOWED_TESTER_MAP.get(clazz);
            if (tester2 == null || !(failureMessage = tester2.isInteractionAllowed(player, worldState, schematicState)).isPresent()) continue;
            return Result.bad(failureMessage.get());
        }
        return canConsume ? Result.good() : Result.no();
    }

    static {
        BlockInteractionRestrictor.interactAble(ButtonBlock.class).notAllowed();
        BlockInteractionRestrictor.interactAble(FurnaceBlock.class);
        BlockInteractionRestrictor.interactAble(SignBlock.class);
        BlockInteractionRestrictor.interactAble(AnvilBlock.class);
        BlockInteractionRestrictor.interactAble(BarrelBlock.class);
        BlockInteractionRestrictor.interactAble(BeaconBlock.class);
        BlockInteractionRestrictor.interactAble(BedBlock.class);
        BlockInteractionRestrictor.interactAble(BrewingStandBlock.class);
        BlockInteractionRestrictor.interactAble(CakeBlock.class).when((player, worldState) -> player.canEat(false)).allowIf(InteractAllowedTesters.unequalProperty(CakeBlock.BITES));
        BlockInteractionRestrictor.interactAble(CartographyTableBlock.class);
        BlockInteractionRestrictor.interactAble(CauldronBlock.class).notAllowed();
        BlockInteractionRestrictor.interactAble(ChestBlock.class);
        BlockInteractionRestrictor.interactAble(ComparatorBlock.class).when(InteractAbleTester.playerCanModifyWorld()).allowIf(InteractAllowedTesters.unequalProperty(ComparatorBlock.MODE));
        BlockInteractionRestrictor.interactAble(CraftingTableBlock.class);
        BlockInteractionRestrictor.interactAble(DaylightDetectorBlock.class).when(InteractAbleTester.playerCanModifyWorld()).allowIf(InteractAllowedTesters.unequalProperty(DaylightDetectorBlock.INVERTED));
        BlockInteractionRestrictor.interactAble(DispenserBlock.class);
        BlockInteractionRestrictor.interactAble(DoorBlock.class).when(InteractAbleTester.canOpenByHand()).allowIf(InteractAllowedTesters.unequalProperty(DoorBlock.OPEN));
        BlockInteractionRestrictor.interactAble(EnchantingTableBlock.class);
        BlockInteractionRestrictor.interactAble(EnderChestBlock.class);
        BlockInteractionRestrictor.interactAble(FenceGateBlock.class).allowIf(InteractAllowedTesters.unequalProperty(FenceGateBlock.OPEN));
        BlockInteractionRestrictor.interactAble(GrindstoneBlock.class);
        BlockInteractionRestrictor.interactAble(LeverBlock.class).allowIf(InteractAllowedTesters.unequalProperty(LeverBlock.POWERED));
        BlockInteractionRestrictor.interactAble(LoomBlock.class);
        BlockInteractionRestrictor.interactAble(NoteBlock.class).allowIf(InteractAllowedTesters.unequalProperty(NoteBlock.NOTE));
        BlockInteractionRestrictor.interactAble(RepeaterBlock.class).when(InteractAbleTester.playerCanModifyWorld()).allowIf(InteractAllowedTesters.unequalProperty(RepeaterBlock.DELAY));
        BlockInteractionRestrictor.interactAble(ShulkerBoxBlock.class);
        BlockInteractionRestrictor.interactAble(StonecutterBlock.class);
        BlockInteractionRestrictor.interactAble(TrapDoorBlock.class).when(InteractAbleTester.canOpenByHand()).allowIf(InteractAllowedTesters.unequalProperty(DoorBlock.OPEN));
    }

    private static class RequirementBuilder {
        private final Class<? extends Block> blockClass;

        private RequirementBuilder(Class<? extends Block> blockClass) {
            this.blockClass = blockClass;
            INTERACT_ABLE_TESTER_MAP.put(this.blockClass, InteractAbleTester.always());
        }

        private RequirementBuilder when(InteractAbleTester ... testers) {
            InteractAbleTester tester = InteractAbleTester.always();
            for (InteractAbleTester t : testers) {
                tester = tester.and(t);
            }
            INTERACT_ABLE_TESTER_MAP.put(this.blockClass, tester);
            return this;
        }

        private RequirementBuilder allowIf(InteractAllowedTester tester) {
            INTERACT_ALLOWED_TESTER_MAP.put(this.blockClass, tester);
            return this;
        }

        private void notAllowed() {
            INTERACT_ALLOWED_TESTER_MAP.put(this.blockClass, InteractAllowedTesters.notAllowed());
        }
    }

    public static class Result {
        private final ResultType type;
        private final String message;

        private Result(ResultType type, String message) {
            this.type = type;
            this.message = message;
        }

        public static Result no() {
            return new Result(ResultType.NO_INTERACTION, "");
        }

        public static Result good() {
            return new Result(ResultType.GOOD_INTERACTION, "");
        }

        public static Result bad(String message) {
            return new Result(ResultType.BAD_INTERACTION, message);
        }

        public ResultType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum ResultType {
        NO_INTERACTION,
        GOOD_INTERACTION,
        BAD_INTERACTION;

    }
}

