/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.blockEventThrottler;

import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.blockEventThrottler.TimedCounter;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.RegistryUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class BlockEventThrottler {
    public static void throttle(Level world, BlockPos pos, Block block, TimedCounter counter, CallbackInfo ci) {
        double whitelistRange;
        if (!TweakerMoreConfigs.BLOCK_EVENT_THROTTLER.getBooleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || world != mc.level) {
            return;
        }
        String blockId = RegistryUtils.getBlockId(block);
        if (TweakerMoreConfigs.BLOCK_EVENT_THROTTLER_TARGET_BLOCKS.getStrings().stream().noneMatch(target -> target.equals(blockId))) {
            return;
        }
        counter.updateTime(world.getGameTime());
        if (++counter.amount <= TweakerMoreConfigs.BLOCK_EVENT_THROTTLER_THRESHOLD.getIntegerValue()) {
            return;
        }
        double disSqr = mc.player.distanceToSqr(PositionUtils.centerOf(pos));
        if (disSqr < (whitelistRange = TweakerMoreConfigs.BLOCK_EVENT_THROTTLER_WHITELIST_RANGE.getDoubleValue()) * whitelistRange) {
            return;
        }
        ci.cancel();
    }
}

