/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder.AbstractHintBuilder;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.Nullable;

public class PotionHintBuilder
extends AbstractHintBuilder {
    @Override
    @Nullable
    public Component build(Item.TooltipContext context, ItemStack itemStack) {
        if (TweakerMoreConfigs.SHULKER_BOX_TOOLTIP_POTION_INFO_HINT.getBooleanValue()) {
            Item item = itemStack.getItem();
            float ratio = PotionHintBuilder.getPotionDurationRatio(item);
            PotionContents potions = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
            if (ratio > 0.0f && potions != null) {
                int i;
                ArrayList potionTexts = Lists.newArrayList();
                ClientLevel world = Minecraft.getInstance().level;
                float tickRate = world != null ? world.tickRateManager().tickrate() : 20.0f;
                PotionContents.addPotionTooltip((Iterable)potions.getAllEffects(), potionTexts::add, (float)ratio, (float)tickRate);
                MutableComponent newLine = Messenger.s("");
                for (i = 0; i < potionTexts.size() && !((Component)potionTexts.get(i)).equals((Object)newLine); ++i) {
                }
                return PotionHintBuilder.buildSegments(potionTexts.subList(0, i));
            }
        }
        return null;
    }

    private static float getPotionDurationRatio(Item item) {
        if (item instanceof LingeringPotionItem) {
            return 0.25f;
        }
        if (item instanceof TippedArrowItem) {
            return 0.125f;
        }
        if (item instanceof PotionItem) {
            return 1.0f;
        }
        return -1.0f;
    }
}

