/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace;

import com.mojang.datafixers.util.Pair;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.ProPlaceImpl;
import me.fallenbreath.tweakermore.util.BlockUtils;
import me.fallenbreath.tweakermore.util.compat.tweakeroo.TweakerooAccess;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Restriction(require={@Condition(value="tweakerge"), @Condition(value="forgematica")})
@Mixin(value={PlacementTweaks.class})
public abstract class PlacementTweaksMixin {
    @Shadow(remap=false)
    private static boolean firstWasRotation;
    @Shadow
    private static ItemStack[] stackBeforeUse;

    @Unique
    private static BlockHitResult finalBlockPlacementTweak$TKM(LocalPlayer player, ClientLevel world, BlockPos posIn, Direction sideIn, Vec3 hitVecIn, InteractionHand hand) {
        BlockHitResult hitResult = new BlockHitResult(hitVecIn, sideIn, posIn, false);
        BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
        BlockState state = world.getBlockState(posIn);
        ItemStack stackOriginal = !stackBeforeUse[hand.ordinal()].isEmpty() && !FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getBooleanValue() && !FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getBooleanValue() ? stackBeforeUse[hand.ordinal()] : player.getItemInHand(hand).copy();
        if (FeatureToggle.TWEAK_PLACEMENT_RESTRICTION.getBooleanValue() && !state.canBeReplaced(ctx) && BlockUtils.isReplaceable(state)) {
            posIn = posIn.offset(sideIn.getOpposite().getNormal());
        }
        int afterClickerClickCount = Mth.clamp((int)Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getIntegerValue(), (int)0, (int)32);
        Direction facing = sideIn;
        boolean flexible = FeatureToggle.TWEAK_FLEXIBLE_BLOCK_PLACEMENT.getBooleanValue();
        boolean rotationHeld = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ROTATION.getKeybind().isKeybindHeld();
        boolean rememberFlexible = Configs.Generic.REMEMBER_FLEXIBLE.getBooleanValue();
        boolean rotation = rotationHeld || rememberFlexible && firstWasRotation;
        boolean accurate = FeatureToggle.TWEAK_ACCURATE_BLOCK_PLACEMENT.getBooleanValue();
        boolean keys = Hotkeys.ACCURATE_BLOCK_PLACEMENT_IN.getKeybind().isKeybindHeld() || Hotkeys.ACCURATE_BLOCK_PLACEMENT_REVERSE.getKeybind().isKeybindHeld();
        boolean bl = accurate = accurate && keys;
        if (flexible && rotation && !accurate && TweakerooAccess.getAccuratePlacementProtocolValue() && fi.dy.masa.malilib.util.BlockUtils.isFacingValidForDirection((ItemStack)stackOriginal, (Direction)facing)) {
            facing = facing.getOpposite();
            double x = posIn.getX() + 2 + facing.ordinal() * 2;
            if (FeatureToggle.TWEAK_AFTER_CLICKER.getBooleanValue()) {
                x += (double)(afterClickerClickCount * 16);
            }
            hitVecIn = new Vec3(x, hitVecIn.y, hitVecIn.z);
        }
        if (FeatureToggle.TWEAK_Y_MIRROR.getBooleanValue() && Hotkeys.PLACEMENT_Y_MIRROR.getKeybind().isKeybindHeld()) {
            double y = 1.0 - hitVecIn.y + (double)(2 * posIn.getY());
            hitVecIn = new Vec3(hitVecIn.x, y, hitVecIn.z);
            if (sideIn.getAxis() == Direction.Axis.Y) {
                posIn = posIn.offset(sideIn.getNormal());
                sideIn = sideIn.getOpposite();
            }
        }
        return new BlockHitResult(hitVecIn, sideIn, posIn, false);
    }

    @Inject(method={"processRightClickBlockWrapper"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void schematicProPlace(MultiPlayerGameMode controller, LocalPlayer player, ClientLevel world, BlockPos posIn, Direction sideIn, Vec3 hitVecIn, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ProPlaceImpl.handleRightClick(() -> {
            BlockHitResult hitResult = PlacementTweaksMixin.finalBlockPlacementTweak$TKM(player, world, posIn, sideIn, hitVecIn, hand);
            BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
            return Pair.of((Object)hitResult, (Object)ctx);
        }, cir);
    }
}

