/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.mc_tweaks.steveAlexOnlyDefaultSkins;

import java.util.UUID;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.19.3"})})
@Mixin(value={DefaultPlayerSkin.class})
public abstract class DefaultSkinHelperMixin {
    @Shadow
    @Final
    private static PlayerSkin[] DEFAULT_SKINS;

    @Inject(method={"get(Ljava/util/UUID;)Lnet/minecraft/client/resources/PlayerSkin;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void steveAlexOnlyDefaultSkins_overrideAlgorithm(UUID uuid, CallbackInfoReturnable<PlayerSkin> cir) {
        if (TweakerMoreConfigs.STEVE_ALEX_ONLY_DEFAULT_SKINS.getBooleanValue()) {
            boolean shouldUseSlimModel = (uuid.hashCode() & 1) == 1;
            String keyword = shouldUseSlimModel ? "/alex.png" : "/steve.png";
            for (PlayerSkin skin : DEFAULT_SKINS) {
                if (!skin.texture().getPath().endsWith(keyword)) continue;
                cir.setReturnValue((Object)skin);
                return;
            }
            TweakerMoreMod.LOGGER.warn("Cannot locate default skin with suffix {}", (Object)keyword);
        }
    }
}

