/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.mod_tweaks.serverDataSyncer.tweakermore;

import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.UUID;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mod_tweaks.mlShulkerBoxPreviewSupportEnderChest.EnderChestItemFetcher;
import me.fallenbreath.tweakermore.impl.mod_tweaks.mlShulkerBoxPreviewSupportEnderChest.EnderItemNbtUtils;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.ServerDataSyncer;
import me.fallenbreath.tweakermore.mixins.tweaks.mod_tweaks.mlShulkerBoxPreviewSupportEnderChest.BasicInventoryAccessor;
import me.fallenbreath.tweakermore.util.collection.ExpiringMap;
import me.fallenbreath.tweakermore.util.event.TweakerMoreEvents;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderChestItemFetcher.class})
public abstract class EnderChestItemFetcherMixin {
    @Unique
    private static final ExpiringMap<UUID, PlayerEnderChestContainer> CACHE = new ExpiringMap(Maps.newHashMap(), 5000);
    @Unique
    private static final long COOLDOWN_MS = 250L;
    @Unique
    private static long prevMilli = 0L;

    @Inject(method={"getEntityData"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void serverDataSyncer4mlShulkerBoxPreviewSupportEnderChest(@Coerce Entity entity, CallbackInfoReturnable<Optional<NonNullList<ItemStack>>> cir) {
        if (TweakerMoreConfigs.SERVER_DATA_SYNCER.getBooleanValue() && ServerDataSyncer.hasEnoughPermission() && entity instanceof Player) {
            PlayerEnderChestContainer inventory;
            Player player = (Player)entity;
            UUID uuid = player.getUUID();
            long now = System.currentTimeMillis();
            if (now - prevMilli >= 250L) {
                prevMilli = now;
                ServerDataSyncer.getInstance().fetchEntity((Entity)player).ifPresent(future -> {
                    PlayerEnderChestContainer enderChestInventory = CACHE.computeIfAbsent(uuid, k -> new PlayerEnderChestContainer());
                    CACHE.keepAlive(uuid);
                    future.thenAccept(nbt -> {
                        if (nbt != null && EnderItemNbtUtils.containsList(nbt, "EnderItems")) {
                            enderChestInventory.fromTag(EnderItemNbtUtils.getNbtListOrEmpty(nbt, "EnderItems"), (HolderLookup.Provider)player.registryAccess());
                        }
                    });
                });
            }
            if ((inventory = CACHE.get(uuid)) != null) {
                cir.setReturnValue(Optional.ofNullable(((BasicInventoryAccessor)inventory).getItemList()));
            }
        }
    }

    static {
        TweakerMoreEvents.registerDimensionChangedCallback(() -> {
            CACHE.clear();
            prevMilli = 0L;
        });
    }
}

