/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Messenger {
    public static MutableComponent s(Object text) {
        return Component.literal((String)text.toString());
    }

    public static MutableComponent tf(Object text) {
        return text instanceof MutableComponent ? (MutableComponent)text : Messenger.s(text);
    }

    public static MutableComponent c(Object ... fields) {
        MutableComponent text = Messenger.s("");
        for (Object field : fields) {
            text.append((Component)Messenger.tf(field));
        }
        return text;
    }

    public static MutableComponent s(Object text, ChatFormatting textFormatting) {
        return Messenger.formatting(Messenger.s(text), textFormatting);
    }

    public static MutableComponent tr(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static MutableComponent fancy(@NotNull MutableComponent displayText, @Nullable MutableComponent hoverText, @Nullable ClickEvent clickEvent) {
        MutableComponent text = Messenger.copy(displayText);
        if (hoverText != null) {
            Messenger.hover(text, hoverText);
        }
        if (clickEvent != null) {
            Messenger.click(text, clickEvent);
        }
        return text;
    }

    public static MutableComponent join(MutableComponent joiner, Component ... items) {
        MutableComponent text = Messenger.s("");
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                text.append((Component)joiner);
            }
            text.append(items[i]);
        }
        return text;
    }

    public static MutableComponent hover(MutableComponent text, HoverEvent hoverEvent) {
        Messenger.style(text, text.getStyle().withHoverEvent(hoverEvent));
        return text;
    }

    public static MutableComponent hover(MutableComponent text, MutableComponent hoverText) {
        return Messenger.hover(text, new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverText));
    }

    public static MutableComponent click(MutableComponent text, ClickEvent clickEvent) {
        Messenger.style(text, text.getStyle().withClickEvent(clickEvent));
        return text;
    }

    public static MutableComponent formatting(MutableComponent text, ChatFormatting ... formattings) {
        text.withStyle(formattings);
        return text;
    }

    public static MutableComponent style(MutableComponent text, Style style) {
        text.setStyle(style);
        return text;
    }

    public static MutableComponent copy(MutableComponent text) {
        return text.copy();
    }
}

