/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.compat.litematica;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import java.util.Optional;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.util.PlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LitematicaUtils {
    private static final boolean LITEMATICA_LOADED = PlatformUtils.isModLoaded("forgematica");

    @Nullable
    public static Level getSchematicWorld() {
        if (LITEMATICA_LOADED) {
            return SchematicWorldHandler.getSchematicWorld();
        }
        return null;
    }

    public static boolean isRenderingEnabled() {
        if (LITEMATICA_LOADED) {
            return Configs.Visuals.ENABLE_RENDERING.getBooleanValue();
        }
        return false;
    }

    @Nullable
    public static BlockPos getSchematicWorldCrosshairTargetPos(Entity cameraEntity) {
        if (LITEMATICA_LOADED) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                try {
                    return Optional.ofNullable(RayTraceUtils.getGenericTrace((Level)mc.level, (Entity)cameraEntity, (double)10.0, (boolean)true, (boolean)Configs.InfoOverlays.INFO_OVERLAYS_TARGET_FLUIDS.getBooleanValue(), (boolean)false)).map(RayTraceUtils.RayTraceWrapper::getBlockHitResult).map(BlockHitResult::getBlockPos).orElse(null);
                }
                catch (NoSuchMethodError e) {
                    TweakerMoreMod.LOGGER.warn("LitematicaUtils.getSchematicWorldCrosshairTargetPos failed: {}", (Object)e.toString());
                    return null;
                }
            }
        }
        return null;
    }
}

