/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.damage;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class DamageUtil {
    public static float modifyDamageForDifficulty(float amount, Difficulty difficulty) {
        switch (difficulty) {
            case PEACEFUL: {
                amount = 0.0f;
                break;
            }
            case EASY: {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
                break;
            }
            case HARD: {
                amount = amount * 3.0f / 2.0f;
            }
        }
        return amount;
    }

    public static float modifyDamageForDifficulty(float amount, Difficulty difficulty, DamageSource damageSource) {
        if (damageSource.scalesWithDifficulty()) {
            amount = DamageUtil.modifyDamageForDifficulty(amount, difficulty);
        }
        return amount;
    }

    public static float getDamageLeft(LivingEntity armorWearer, float damageAmount, DamageSource damageSource, float armor, float armorToughness) {
        float i;
        Level world;
        float f = 2.0f + armorToughness / 4.0f;
        float g = Mth.clamp((float)(armor - damageAmount / f), (float)(armor * 0.2f), (float)20.0f);
        float h = g / 25.0f;
        ItemStack itemStack = damageSource.getWeaponItem();
        if (itemStack != null && (world = armorWearer.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            i = Mth.clamp((float)EnchantmentHelper.getDamageProtection((ServerLevel)serverWorld, (LivingEntity)armorWearer, (DamageSource)damageSource), (float)0.0f, (float)1.0f);
        } else {
            i = h;
        }
        float j = 1.0f - i;
        return damageAmount * j;
    }

    public static float getInflictedDamage(float damageDealt, float protection) {
        float f = Mth.clamp((float)protection, (float)0.0f, (float)20.0f);
        return damageDealt * (1.0f - f / 25.0f);
    }
}

