/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.doc;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.IConfigStringList;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.IStringRepresentable;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.Config;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.TweakerMoreOption;
import me.fallenbreath.tweakermore.config.options.IHotkeyWithSwitch;
import me.fallenbreath.tweakermore.config.options.IOptionListHotkeyed;
import me.fallenbreath.tweakermore.config.options.TweakerMoreIConfigBase;
import me.fallenbreath.tweakermore.util.StringUtils;
import me.fallenbreath.tweakermore.util.condition.ModPredicate;
import me.fallenbreath.tweakermore.util.condition.ModRestriction;
import net.neoforged.fml.loading.FMLPaths;

public class DocumentPrinter {
    private static final Path DOC_DIRECTORY = FMLPaths.GAMEDIR.get().getParent().resolve("docs");
    private static final String ASSETS_DIRECTORY_NAME = "assets";
    private static final Path ASSETS_DIRECTORY = DOC_DIRECTORY.resolve("assets");

    private static String codeBlock(String text) {
        return "`" + text + "`";
    }

    private static String italic(String text) {
        return "*" + text + "*";
    }

    private static String prettyPredicate(ModPredicate modPredicate) {
        Object ret = String.format("%s (`%s`)", fi.dy.masa.malilib.util.StringUtils.translate((String)("tweakermore.util.mod." + modPredicate.modId), (Object[])new Object[0]), modPredicate.modId);
        String predicate = modPredicate.getVersionPredicatesString();
        if (!predicate.isEmpty()) {
            ret = (String)ret + " " + DocumentPrinter.codeBlock(predicate);
        }
        return ret;
    }

    private static String getConfigType(IConfigBase config) {
        String id = config instanceof IHotkeyTogglable ? "hotkey_togglable" : (config instanceof IHotkeyWithSwitch ? "hotkey_with_switch" : (config instanceof IOptionListHotkeyed ? "option_list_hotkeyed" : config.getType().name().toLowerCase()));
        return fi.dy.masa.malilib.util.StringUtils.translate((String)("tweakermore.doc_gen.type." + id), (Object[])new Object[0]);
    }

    private static String getComment(TweakerMoreIConfigBase config) {
        return StringUtils.removeFormattingCode(config.getCommentNoFooter());
    }

    private static String getDefaultValue(IConfigBase config) {
        String hotkey = "";
        if (config instanceof IHotkey) {
            hotkey = ((IHotkey)config).getKeybind().getDefaultStringValue();
            hotkey = hotkey.isEmpty() ? DocumentPrinter.italic(fi.dy.masa.malilib.util.StringUtils.translate((String)"tweakermore.doc_gen.value.no_hotkey", (Object[])new Object[0])) : DocumentPrinter.codeBlock(hotkey);
        }
        if (config == TweakerMoreConfigs.LM_CUSTOM_SCHEMATIC_BASE_DIRECTORY_PORTING) {
            return DocumentPrinter.codeBlock("<path_to_mc_dir>/schematics");
        }
        if (config instanceof IHotkeyTogglable) {
            return hotkey + ", " + DocumentPrinter.codeBlock(String.valueOf(((IHotkeyTogglable)config).getDefaultBooleanValue()));
        }
        if (config instanceof IConfigStringList) {
            return DocumentPrinter.codeBlock(((IConfigStringList)config).getDefaultStrings().toString());
        }
        if (config instanceof IConfigOptionList) {
            return DocumentPrinter.codeBlock(((IConfigOptionList)config).getDefaultOptionListValue().getDisplayName());
        }
        if (config instanceof IHotkey) {
            return hotkey;
        }
        if (config instanceof IStringRepresentable) {
            return DocumentPrinter.codeBlock(((IStringRepresentable)config).getDefaultStringValue());
        }
        TweakerMoreMod.LOGGER.warn("Unknown type found in getDefaultValue: {}", (Object)config.getClass());
        return DocumentPrinter.italic("unknown type: " + config.getClass().getName());
    }

    private static Optional<Number> getMinValue(IConfigBase config) {
        if (config instanceof IConfigInteger) {
            return Optional.of(((IConfigInteger)config).getMinIntegerValue());
        }
        if (config instanceof IConfigDouble) {
            return Optional.of(((IConfigDouble)config).getMinDoubleValue());
        }
        return Optional.empty();
    }

    private static Optional<Number> getMaxValue(IConfigBase config) {
        if (config instanceof IConfigInteger) {
            return Optional.of(((IConfigInteger)config).getMaxIntegerValue());
        }
        if (config instanceof IConfigDouble) {
            return Optional.of(((IConfigDouble)config).getMaxDoubleValue());
        }
        return Optional.empty();
    }

    private static Optional<List<String>> getOptionListValueNames(IConfigBase config) {
        if (config instanceof IConfigOptionList) {
            IConfigOptionListEntry firstValue = ((IConfigOptionList)config).getDefaultOptionListValue();
            ArrayList values = Lists.newArrayList();
            boolean allEnum = true;
            IConfigOptionListEntry value = firstValue;
            do {
                allEnum &= value instanceof Enum;
                values.add(value);
            } while ((value = value.cycle(true)) != firstValue);
            if (allEnum) {
                values.sort(Comparator.comparingInt(v -> ((Enum)v).ordinal()));
            }
            return Optional.of(values.stream().map(IConfigOptionListEntry::getDisplayName).map(DocumentPrinter::codeBlock).collect(Collectors.toList()));
        }
        return Optional.empty();
    }

    private static Optional<String> getScreenShotFileName(String configId, String lang) {
        for (String extension : new String[]{"png", "gif"}) {
            String fileName = String.format("%s-%s.%s", configId, lang, extension);
            if (ASSETS_DIRECTORY.resolve(fileName).toFile().isFile()) {
                return Optional.of(fileName);
            }
            fileName = String.format("%s.%s", configId, extension);
            if (!ASSETS_DIRECTORY.resolve(fileName).toFile().isFile()) continue;
            return Optional.of(fileName);
        }
        return Optional.empty();
    }

    private static String tr(String key) {
        return fi.dy.masa.malilib.util.StringUtils.translate((String)("tweakermore.doc_gen.text." + key), (Object[])new Object[0]);
    }

    private static void printOption(Consumer<String> writeln, TweakerMoreOption tweakerMoreOption, String lang) {
        TweakerMoreIConfigBase config = tweakerMoreOption.getConfig();
        String configId = config.getName();
        Object title = config.getConfigGuiDisplayName();
        if (!((String)title).equals(configId)) {
            title = (String)title + String.format(" (%s)", configId);
        }
        writeln.accept("### " + (String)title);
        writeln.accept("");
        writeln.accept(DocumentPrinter.getComment(config).replace("\n", "\n\n"));
        writeln.accept("");
        writeln.accept(String.format("- %s: %s", DocumentPrinter.tr("category"), tweakerMoreOption.getCategory().getDisplayName()));
        writeln.accept(String.format("- %s: %s (%s)", DocumentPrinter.tr("type"), DocumentPrinter.getConfigType(config), tweakerMoreOption.getType().getStringValue()));
        writeln.accept(String.format("- %s: %s", DocumentPrinter.tr("default_value"), DocumentPrinter.getDefaultValue(config)));
        DocumentPrinter.getMinValue(config).ifPresent(min -> writeln.accept(String.format("- %s: `%s`", DocumentPrinter.tr("minimum_value"), min)));
        DocumentPrinter.getMaxValue(config).ifPresent(max -> writeln.accept(String.format("- %s: `%s`", DocumentPrinter.tr("maximum_value"), max)));
        DocumentPrinter.getOptionListValueNames(config).ifPresent(values -> writeln.accept(String.format("- %s: %s", DocumentPrinter.tr("options"), Joiner.on((String)", ").join((Iterable)values))));
        List<ModRestriction> modRestrictions = tweakerMoreOption.getModRestrictions();
        if (!modRestrictions.isEmpty()) {
            writeln.accept(String.format("- %s:", DocumentPrinter.tr("mod_restrictions")));
            boolean first = true;
            for (ModRestriction modRestriction : modRestrictions) {
                if (!first) {
                    writeln.accept("");
                    writeln.accept(String.format("  *%s*", fi.dy.masa.malilib.util.StringUtils.translate((String)"tweakermore.gui.mod_relation_footer.or", (Object[])new Object[0])));
                    writeln.accept("");
                }
                first = false;
                if (!modRestriction.getRequirements().isEmpty()) {
                    writeln.accept(String.format("  - %s:", DocumentPrinter.tr("requirements")));
                    modRestriction.getRequirements().forEach(req -> writeln.accept(String.format("    - %s", DocumentPrinter.prettyPredicate(req))));
                }
                if (modRestriction.getConflictions().isEmpty()) continue;
                writeln.accept(String.format("  - %s:", DocumentPrinter.tr("conflictions")));
                modRestriction.getConflictions().forEach(cfl -> writeln.accept(String.format("    - %s", DocumentPrinter.prettyPredicate(cfl))));
            }
        }
        writeln.accept("");
        DocumentPrinter.getScreenShotFileName(configId, lang).ifPresent(fileName -> {
            writeln.accept(String.format("![%s](%s/%s)", configId, ASSETS_DIRECTORY_NAME, fileName));
            writeln.accept("");
        });
        writeln.accept("");
    }

    public static void printDoc(String lang) {
        TweakerMoreMod.LOGGER.info("Dumping language with language {}", (Object)lang);
        StringBuffer buffer = new StringBuffer();
        Consumer<String> writeln = line -> buffer.append((String)line).append("\n");
        for (Config.Category category : Config.Category.values()) {
            if (category == Config.Category.ALL) continue;
            writeln.accept("## " + category.getDisplayName());
            writeln.accept("");
            writeln.accept(category.getDescription());
            writeln.accept("");
            ArrayList options = Lists.newArrayList(TweakerMoreConfigs.getOptions(category));
            options.sort((a, b) -> a.getConfig().getName().compareToIgnoreCase(b.getConfig().getName()));
            for (TweakerMoreOption tweakerMoreOption : options) {
                if (tweakerMoreOption.isDebug() || tweakerMoreOption.isDevOnly()) continue;
                DocumentPrinter.printOption(writeln, tweakerMoreOption, lang);
            }
        }
        Path filePath = DOC_DIRECTORY.resolve(String.format("document-%s.md", lang));
        TweakerMoreMod.LOGGER.info("Doc file path: {}", (Object)filePath);
        try {
            if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(buffer.toString());
            }
        }
        catch (IOException e) {
            TweakerMoreMod.LOGGER.error((Object)e);
        }
    }
}

