/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.render;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import me.fallenbreath.tweakermore.mixins.util.render.TextHandlerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.tuple.Triple;

public class TextRenderingUtil {
    public static FormattedCharSequence string2orderedText(String string) {
        return visitor -> StringDecomposer.iterate((String)string, (Style)Style.EMPTY, (FormattedCharSink)visitor);
    }

    public static String orderedText2string(FormattedCharSequence text) {
        StringBuilder builder = new StringBuilder();
        text.accept((index, style, codePoint) -> {
            builder.append((char)codePoint);
            return true;
        });
        return builder.toString();
    }

    public static FormattedCharSequence trim(FormattedCharSequence text, int maxWidth, PostTrimModifier<FormattedCharSequence> postTrimModifier) {
        Font textRenderer = Minecraft.getInstance().font;
        StringSplitter.WidthProvider widthRetriever = ((TextHandlerAccessor)textRenderer.getSplitter()).getWidthRetriever();
        ArrayList elements = Lists.newArrayList();
        MutableFloat width = new MutableFloat(0.0f);
        boolean hasTrimmed = text.accept((index, style, codePoint) -> {
            boolean ok;
            width.add(widthRetriever.getWidth(codePoint, style));
            boolean bl = ok = width.getValue().floatValue() <= (float)maxWidth;
            if (ok) {
                elements.add(Triple.of((Object)index, (Object)style, (Object)codePoint));
            }
            return ok;
        });
        FormattedCharSequence trimmedText = visitor -> {
            for (Triple element : elements) {
                if (visitor.accept(((Integer)element.getLeft()).intValue(), (Style)element.getMiddle(), ((Integer)element.getRight()).intValue())) continue;
                return false;
            }
            return true;
        };
        if (hasTrimmed) {
            trimmedText = postTrimModifier.modify(trimmedText);
        }
        return trimmedText;
    }

    public static FormattedCharSequence trim(FormattedCharSequence text, int maxWidth) {
        return TextRenderingUtil.trim(text, maxWidth, (FormattedCharSequence t) -> t);
    }

    public static String trim(String text, int maxWidth, PostTrimModifier<String> postTrimModifier) {
        Minecraft mc = Minecraft.getInstance();
        String trimmedText = mc.font.plainSubstrByWidth(text, maxWidth);
        if (trimmedText.length() < text.length()) {
            trimmedText = postTrimModifier.modify(trimmedText);
        }
        return trimmedText;
    }

    public static String trim(String text, int maxWidth) {
        return TextRenderingUtil.trim(text, maxWidth, (String t) -> t);
    }

    @FunctionalInterface
    public static interface PostTrimModifier<T> {
        public T modify(T var1);
    }
}

