/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.render.context;

import com.mojang.blaze3d.vertex.PoseStack;
import me.fallenbreath.tweakermore.util.render.context.RenderContextImpl;
import me.fallenbreath.tweakermore.util.render.context.RenderContextUtils;
import me.fallenbreath.tweakermore.util.render.context.WorldRenderContextImpl;
import me.fallenbreath.tweakermore.util.render.matrix.IMatrixStack;
import me.fallenbreath.tweakermore.util.render.matrix.JomlMatrixStack;
import me.fallenbreath.tweakermore.util.render.matrix.McMatrixStack;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public interface RenderContext {
    public static RenderContext of(@NotNull PoseStack matrixStack) {
        return new RenderContextImpl(RenderContextUtils.createDrawContext(matrixStack), new McMatrixStack(matrixStack));
    }

    public static WorldRenderContextImpl createWorldRenderContext(@NotNull Matrix4fStack matrixStack) {
        return new WorldRenderContextImpl(RenderContextUtils.createDrawContext(new PoseStack()), new JomlMatrixStack(matrixStack));
    }

    public static RenderContext of(@NotNull GuiGraphics drawContext) {
        return new RenderContextImpl(drawContext, new McMatrixStack(drawContext.pose()));
    }

    public static RenderContext of(@NotNull Matrix4fStack matrixStack) {
        return new RenderContextImpl(RenderContextUtils.createDrawContext(new PoseStack()), new JomlMatrixStack(matrixStack));
    }

    public GuiGraphics getGuiDrawer();

    @NotNull
    public IMatrixStack getMatrixStack();

    public void pushMatrix();

    public void popMatrix();

    public void translate(double var1, double var3, double var5);

    public void scale(double var1, double var3, double var5);

    public void multMatrix(Matrix4f var1);
}

