/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors;

import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.List;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.TweakerMoreConfigBooleanHotkeyed;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerProcessorUtils;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.IContainerProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ProcessResult;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.Slot;

public class ContainerCleaner
implements IContainerProcessor {
    @Override
    public TweakerMoreConfigBooleanHotkeyed getConfig() {
        return TweakerMoreConfigs.AUTO_CLEAN_CONTAINER;
    }

    @Override
    public ProcessResult process(LocalPlayer player, AbstractContainerScreen<?> containerScreen, List<Slot> allSlots, List<Slot> playerInvSlots, List<Slot> containerInvSlots) {
        if (ContainerProcessorUtils.shouldSkipForEnderChest(containerScreen, (ConfigBoolean)TweakerMoreConfigs.AUTO_CLEAN_CONTAINER_IGNORE_ENDER_CHEST)) {
            return ProcessResult.skipped();
        }
        int counter = 0;
        for (Slot slot : containerInvSlots) {
            if (!slot.hasItem() || !TweakerMoreConfigs.AUTO_CLEAN_CONTAINER_RESTRICTION.isAllowed((Object)slot.getItem().getItem())) continue;
            InventoryUtils.dropStack(containerScreen, (int)slot.index);
            ++counter;
        }
        InfoUtils.printActionbarMessage((String)"tweakermore.impl.autoCleanContainer.container_cleaned", (Object[])new Object[]{counter, containerScreen.getTitle()});
        return ProcessResult.terminated();
    }
}

