/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler;

import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler.AbstractBlockHandler;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.TemporaryBlockReplacer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BedHandler
extends AbstractBlockHandler {
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private BlockPos bedHeadPos = null;
    private Direction toBedRootDirection;
    private BlockPos bedRootPos = null;

    public BedHandler(RenderVisitorWorldView world, BlockPos blockPos, BlockState blockState) {
        super(world, blockPos, blockState);
        if (blockState.getBlock() instanceof BedBlock) {
            boolean currentIsHead = blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD;
            Direction direction = (Direction)blockState.getValue((Property)BedBlock.FACING);
            if (currentIsHead) {
                direction = direction.getOpposite();
            }
            BlockPos otherPos = blockPos.offset(direction.getNormal());
            BlockState otherState = world.getBlockState(otherPos);
            if (currentIsHead) {
                this.bedHeadPos = blockPos;
                this.toBedRootDirection = direction;
            } else {
                this.toBedRootDirection = direction.getOpposite();
            }
            if (blockState.getBlock() == otherState.getBlock()) {
                this.bedHeadPos = currentIsHead ? blockPos : otherPos;
                this.bedRootPos = currentIsHead ? otherPos : blockPos;
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.bedHeadPos != null) {
            return !BedBlock.canSetSpawn((Level)this.world.getBestWorld());
        }
        return false;
    }

    @Override
    public Vec3 getExplosionCenter() {
        return PositionUtils.centerOf(this.bedHeadPos);
    }

    @Override
    public BlockPos getDeduplicationKey() {
        return this.bedHeadPos;
    }

    @Override
    public void addBlocksToRemove(TemporaryBlockReplacer replacer) {
        replacer.add(this.bedHeadPos, AIR);
        if (this.bedRootPos != null) {
            replacer.add(this.bedRootPos, AIR);
        }
    }

    @Override
    public float getExplosionPower() {
        return 5.0f;
    }

    @Override
    public Vec3 getTextPosition() {
        Vec3 headCenter = PositionUtils.centerOf(this.bedHeadPos);
        Vec3 shiftToMiddle = Vec3.atCenterOf((Vec3i)this.toBedRootDirection.getNormal()).scale(0.5);
        return headCenter.add(shiftToMiddle);
    }
}

