/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.pistorder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.pistorder.PistonActionType;
import me.fallenbreath.tweakermore.impl.features.pistorder.PistorderDisplay;
import me.fallenbreath.tweakermore.mixins.tweaks.features.pistorder.PistonBlockAccessor;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.TweakerMoreIRenderer;
import me.fallenbreath.tweakermore.util.render.context.WorldRenderContextImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class PistorderRenderer
implements TweakerMoreIRenderer,
IClientTickHandler {
    private static final PistorderRenderer INSTANCE = new PistorderRenderer();
    private final Map<Pair<Level, BlockPos>, PistorderDisplay> displayMap = Maps.newHashMap();

    public static PistorderRenderer getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return TweakerMoreConfigs.PISTORDER.getBooleanValue() && TweakerMoreConfigs.PISTORDER.getTweakerMoreOption().isEnabled();
    }

    public InteractionResult onPlayerRightClickBlock(Level world, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isEnabled()) {
            return InteractionResult.FAIL;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            return this.onPlayerRightClickBlockWithMainHand(world, player, hit);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult onPlayerRightClickBlockWithMainHand(Level world, Player player, BlockHitResult hit) {
        boolean extended;
        BlockPos pos;
        BlockState blockState;
        Block block;
        if (!this.isEnabled()) {
            return InteractionResult.FAIL;
        }
        if (player.getMainHandItem().isEmpty() && !player.isShiftKeyDown() && (block = (blockState = world.getBlockState(pos = hit.getBlockPos())).getBlock()) instanceof PistonBaseBlock && (!(extended = ((Boolean)blockState.getValue((Property)PistonBaseBlock.EXTENDED)).booleanValue()) || ((PistonBlockAccessor)block).getIsSticky())) {
            this.click(world, pos, blockState, (Direction)blockState.getValue((Property)PistonBaseBlock.FACING), extended ? PistonActionType.RETRACT : PistonActionType.PUSH);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void click(Level world, BlockPos pos, BlockState blockState, Direction pistonFacing, PistonActionType PistonActionType2) {
        Pair key = Pair.of((Object)world, (Object)pos);
        PistorderDisplay display = this.displayMap.get(key);
        if (display == null) {
            this.displayMap.put((Pair<Level, BlockPos>)key, new PistorderDisplay(world, pos, blockState, pistonFacing, PistonActionType2));
        } else {
            display.onClick();
            if (display.isDisabled()) {
                this.displayMap.remove(key);
            }
        }
    }

    @Override
    public void onRenderWorldLast(WorldRenderContextImpl context) {
        if (!this.isEnabled()) {
            this.displayMap.clear();
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client.player == null) {
            return;
        }
        ArrayList removeList = Lists.newArrayList();
        ArrayList texts = Lists.newArrayList();
        this.displayMap.forEach((key, display) -> {
            texts.addAll(display.render());
            if (display.isDisabled()) {
                removeList.add(key);
            }
        });
        removeList.forEach(this.displayMap::remove);
        double maxDistance = TweakerMoreConfigs.PISTORDER_MAX_RENDER_DISTANCE.getIntegerValue();
        texts.stream().map(tr -> Pair.of((Object)client.player.distanceToSqr(tr.getPos()), (Object)tr)).filter(p -> (Double)p.getFirst() <= maxDistance * maxDistance).sorted(Collections.reverseOrder(Comparator.comparingDouble(Pair::getFirst))).forEach(p -> ((TextRenderer)p.getSecond()).render());
    }

    public void onClientTick(Minecraft mc) {
        this.displayMap.values().forEach(PistorderDisplay::tick);
    }

    public void clearDisplay() {
        if (TweakerMoreConfigs.PISTORDER.getBooleanValue()) {
            InfoUtils.printActionbarMessage((String)"tweakermore.impl.pistorder.display_cleared", (Object[])new Object[0]);
            this.displayMap.clear();
        }
    }
}

