/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict;

import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace.CoralBlockAccessor;
import me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace.CoralFanBlockAccessor;
import me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace.CoralWallFanBlockAccessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;

public class LooseCaseChecker {
    private static boolean isStrict() {
        return TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_STRICT.getBooleanValue();
    }

    public static boolean isLooseCheckSpecialCase(BlockState schematicState, ItemStack schematicStack, ItemStack stackToUse) {
        if (LooseCaseChecker.isStrict()) {
            return false;
        }
        Item itemToUse = stackToUse.getItem();
        if (itemToUse instanceof BlockItem) {
            Block itemToUseBlock = ((BlockItem)itemToUse).getBlock();
            if (LooseCaseChecker.checkDeadCoral(schematicState, schematicStack, stackToUse)) {
                return true;
            }
            if (LooseCaseChecker.checkIce(schematicState, itemToUseBlock)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLooseCheckSpecialCase(BlockState schematicState, Block blockToPlace) {
        return !LooseCaseChecker.isStrict() && (LooseCaseChecker.checkDeadCoral(schematicState, blockToPlace) || LooseCaseChecker.checkIce(schematicState, blockToPlace));
    }

    private static boolean checkDeadCoral(BlockState schematicState, ItemStack schematicStack, ItemStack itemToUse) {
        if (LooseCaseChecker.isDeadCoral(schematicState.getBlock())) {
            Optional<Item> toUseAsDead = LooseCaseChecker.coralLiving2Dead(itemToUse.getItem());
            return toUseAsDead.isPresent() && toUseAsDead.get() == schematicStack.getItem();
        }
        return false;
    }

    private static boolean checkDeadCoral(BlockState schematicState, Block blockToPlace) {
        Block schematicBlock = schematicState.getBlock();
        if (LooseCaseChecker.isDeadCoral(schematicBlock)) {
            Optional<Block> deadCoralToPlace = LooseCaseChecker.coralLiving2Dead(blockToPlace);
            return deadCoralToPlace.isPresent() && deadCoralToPlace.get() == schematicBlock;
        }
        return false;
    }

    private static boolean checkIce(BlockState schematicState, Block blockToPlace) {
        return blockToPlace instanceof IceBlock && schematicState.getFluidState().is(FluidTags.WATER);
    }

    private static Optional<Block> coralLiving2Dead(Block livingCoral) {
        Block deadCoral = null;
        if (livingCoral instanceof CoralBlock) {
            deadCoral = ((CoralBlockAccessor)livingCoral).getDeadBlock();
        } else if (livingCoral instanceof CoralFanBlock) {
            deadCoral = ((CoralFanBlockAccessor)livingCoral).getDeadBlock();
        } else if (livingCoral instanceof CoralWallFanBlock) {
            deadCoral = ((CoralWallFanBlockAccessor)livingCoral).getDeadBlock();
        }
        return Optional.ofNullable(deadCoral);
    }

    private static Optional<Item> coralLiving2Dead(Item livingCoral) {
        if (livingCoral instanceof BlockItem) {
            return LooseCaseChecker.coralLiving2Dead(((BlockItem)livingCoral).getBlock()).map(Block::asItem);
        }
        return Optional.empty();
    }

    private static boolean isLivingCoral(Block block) {
        return LooseCaseChecker.coralLiving2Dead(block).isPresent();
    }

    private static boolean isDeadCoral(Block block) {
        return block instanceof CoralBlock || block.getClass() == CoralFanBlock.class || block.getClass() == CoralWallFanBlock.class;
    }
}

