/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.features.creativePickBlockWithState;

import com.google.common.collect.Maps;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Restriction(require={@Condition(value="minecraft", versionPredicates={"(, 1.21.4)"})})
@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Inject(method={"pickBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void creativePickBlockWithState_storeStateInTag(CallbackInfo ci, boolean isCreative, BlockEntity blockentity, HitResult.Type hitResult, ItemStack itemStack, BlockPos blockPos, BlockState blockState, Block block) {
        if (isCreative && !itemStack.isEmpty() && TweakerMoreConfigs.CREATIVE_PICK_BLOCK_WITH_STATE.isKeybindHeld()) {
            Item item = itemStack.getItem();
            if (item instanceof BlockItem && ((BlockItem)item).getBlock() != blockState.getBlock()) {
                return;
            }
            LinkedHashMap properties = Maps.newLinkedHashMap();
            blockState.getValues().forEach((property, value) -> properties.put(property.getName(), value.toString()));
            itemStack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties((Map)properties));
            InfoUtils.printActionbarMessage((String)"tweakermore.impl.creativePickBlockWithState.message", (Object[])new Object[]{block.getName()});
        }
    }
}

