/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TemporaryBlockReplacer {
    private static final int SET_BLOCK_FLAGS = 16;
    private final Level world;
    private final List<BlockPos> blockPositions = Lists.newArrayList();
    private final List<BlockState> targetStates = Lists.newArrayList();
    private final List<BlockState> originStates = Lists.newArrayList();

    public TemporaryBlockReplacer(Level world) {
        this.world = world;
    }

    public void add(BlockPos pos, BlockState blockState) {
        this.blockPositions.add(pos);
        this.targetStates.add(blockState);
    }

    public void removeBlocks() {
        this.originStates.clear();
        for (BlockPos pos : this.blockPositions) {
            this.originStates.add(this.world.getBlockState(pos));
        }
        for (int i = 0; i < this.blockPositions.size(); ++i) {
            this.world.setBlock(this.blockPositions.get(i), this.targetStates.get(i), 16);
        }
    }

    public void restoreBlocks() {
        for (int i = 0; i < this.blockPositions.size(); ++i) {
            this.world.setBlock(this.blockPositions.get(i), this.originStates.get(i), 16);
        }
    }
}

