/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.damage;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.util.damage.DamageUtil;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;

public class DamageCalculator {
    private final LivingEntity entity;
    private float damageAmount;
    private final DamageSource damageSource;
    private ServerLevel serverWorld = null;
    private ApplyStage currentStage;

    private DamageCalculator(LivingEntity entity, float damageAmount, DamageSource damageSource) {
        this.entity = entity;
        this.damageAmount = damageAmount;
        this.damageSource = damageSource;
        this.currentStage = ApplyStage.NONE;
    }

    public void setServerWorld(ServerLevel serverWorld) {
        this.serverWorld = serverWorld;
    }

    public static DamageCalculator create(LivingEntity entity, float damageAmount, DamageSource damageSource) {
        return new DamageCalculator(entity, damageAmount, damageSource);
    }

    public static DamageCalculator explosion(Vec3 explosionCenter, float explosionPower, LivingEntity entity) {
        int damage;
        float exposure = Explosion.getSeenPercent((Vec3)explosionCenter, (Entity)entity);
        float maxRange = explosionPower * 2.0f;
        double distanceRatio = Math.sqrt(entity.distanceToSqr(explosionCenter)) / (double)maxRange;
        if (distanceRatio <= 1.0) {
            double damageFactor = (1.0 - distanceRatio) * (double)exposure;
            damage = (int)((damageFactor * damageFactor + damageFactor) / 2.0 * 7.0 * (double)maxRange + 1.0);
        } else {
            damage = 0;
        }
        return new DamageCalculator(entity, damage, entity.damageSources().badRespawnPointExplosion(explosionCenter));
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public float getEntityHealthAfterDeal() {
        return Math.max(this.entity.getHealth() - this.damageAmount, 0.0f);
    }

    public float getDamageAmount() {
        return this.damageAmount;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    private void checkAndSetStage(ApplyStage stage) {
        if (stage.ordinal() <= this.currentStage.ordinal()) {
            TweakerMoreMod.LOGGER.warn("DamageCalculator wrong apply order: current {}, applying {}", (Object)this.currentStage, (Object)stage);
        }
        this.currentStage = stage;
    }

    public DamageCalculator applyDifficulty(Difficulty difficulty) {
        this.checkAndSetStage(ApplyStage.DIFFICULTY);
        if (this.entity instanceof Player && this.damageSource.scalesWithDifficulty()) {
            this.damageAmount = DamageUtil.modifyDamageForDifficulty(this.damageAmount, difficulty);
        }
        return this;
    }

    public DamageCalculator applyArmorAndResistanceAndEnchantment() {
        this.checkAndSetStage(ApplyStage.ARMOR);
        float amount = this.damageAmount;
        if (!this.damageSource.is(DamageTypeTags.BYPASSES_ARMOR)) {
            amount = DamageUtil.getDamageLeft(this.entity, amount, this.damageSource, this.entity.getArmorValue(), (float)this.entity.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        if (!this.damageSource.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            float level;
            if (this.entity.hasEffect(MobEffects.DAMAGE_RESISTANCE) && this.damageSource != this.entity.damageSources().outOfBorder()) {
                int level2 = Objects.requireNonNull(this.entity.getEffect(MobEffects.DAMAGE_RESISTANCE)).getAmplifier() + 1;
                amount = Math.max(amount * (1.0f - (float)level2 / 5.0f), 0.0f);
            }
            if (amount > 0.0f && !this.damageSource.is(DamageTypeTags.BYPASSES_ENCHANTMENTS) && (level = this.calculateProtectionEnchantmentAmount()) > 0.0f) {
                amount = DamageUtil.getInflictedDamage(amount, level);
            }
        }
        this.damageAmount = amount;
        return this;
    }

    private static Iterable<ItemStack> getEntityAllArmorItems(LivingEntity entity) {
        return entity.getArmorSlots();
    }

    private float calculateProtectionEnchantmentAmount() {
        if (this.serverWorld != null) {
            return EnchantmentHelper.getDamageProtection((ServerLevel)this.serverWorld, (LivingEntity)this.entity, (DamageSource)this.damageSource);
        }
        DamageSource source = this.damageSource;
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return 0.0f;
        }
        float epf = 0.0f;
        for (ItemStack item : DamageCalculator.getEntityAllArmorItems(this.entity)) {
            for (Object2IntMap.Entry enchantmentEntry : item.getTagEnchantments().entrySet()) {
                ResourceKey enchantment = ((Holder)enchantmentEntry.getKey()).getKey();
                if (enchantment == null) continue;
                int level = enchantmentEntry.getIntValue();
                if (enchantment == Enchantments.PROTECTION) {
                    epf += (float)level;
                    continue;
                }
                if (enchantment == Enchantments.FIRE_PROTECTION && source.is(DamageTypeTags.IS_FIRE)) {
                    epf += (float)(level * 2);
                    continue;
                }
                if (enchantment == Enchantments.FEATHER_FALLING && source.is(DamageTypeTags.IS_FALL)) {
                    epf += (float)(level * 3);
                    continue;
                }
                if (enchantment == Enchantments.BLAST_PROTECTION && source.is(DamageTypeTags.IS_EXPLOSION)) {
                    epf += (float)(level * 2);
                    continue;
                }
                if (enchantment != Enchantments.PROJECTILE_PROTECTION || !source.is(DamageTypeTags.IS_PROJECTILE)) continue;
                epf += (float)(level * 2);
            }
        }
        return epf;
    }

    public DamageCalculator applyAbsorption() {
        this.checkAndSetStage(ApplyStage.ABSORPTION);
        this.damageAmount = Math.max(this.damageAmount - this.entity.getAbsorptionAmount(), 0.0f);
        return this;
    }

    private static enum ApplyStage {
        NONE,
        DIFFICULTY,
        ARMOR,
        ABSORPTION;

    }
}

