/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors;

import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.List;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.TweakerMoreConfigBooleanHotkeyed;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerProcessorUtils;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.IContainerProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ProcessResult;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerFiller
implements IContainerProcessor {
    @Override
    public TweakerMoreConfigBooleanHotkeyed getConfig() {
        return TweakerMoreConfigs.AUTO_FILL_CONTAINER;
    }

    @Override
    public ProcessResult process(LocalPlayer player, AbstractContainerScreen<?> containerScreen, List<Slot> allSlots, List<Slot> playerInvSlots, List<Slot> containerInvSlots) {
        if (ContainerProcessorUtils.shouldSkipForEnderChest(containerScreen, (ConfigBoolean)TweakerMoreConfigs.AUTO_FILL_CONTAINER_IGNORE_ENDER_CHEST)) {
            return ProcessResult.skipped();
        }
        Slot bestSlot = null;
        long maxCount = TweakerMoreConfigs.AUTO_FILL_CONTAINER_THRESHOLD.getIntegerValue() - 1;
        for (Slot slot : playerInvSlots) {
            if (!slot.hasItem() || !containerInvSlots.getFirst().mayPlace(slot.getItem())) continue;
            long cnt = playerInvSlots.stream().filter(slt -> InventoryUtils.areStacksEqual((ItemStack)slot.getItem(), (ItemStack)slt.getItem())).count();
            if (cnt > maxCount) {
                maxCount = cnt;
                bestSlot = slot;
                continue;
            }
            if (cnt != maxCount || bestSlot == null || InventoryUtils.areStacksEqual((ItemStack)slot.getItem(), (ItemStack)bestSlot.getItem())) continue;
            bestSlot = null;
        }
        if (bestSlot != null && !allSlots.isEmpty()) {
            Component stackName = bestSlot.getItem().getHoverName();
            InventoryUtils.tryMoveStacks(bestSlot, containerScreen, (boolean)true, (boolean)true, (boolean)false);
            long amount = containerInvSlots.stream().filter(Slot::hasItem).count();
            long total = containerInvSlots.size();
            boolean isFull = AbstractContainerMenu.getRedstoneSignalFromContainer((Container)containerInvSlots.getFirst().container) >= 15;
            String percentage = String.format("%s%d/%d%s", isFull ? ChatFormatting.GREEN : ChatFormatting.GOLD, amount, total, ChatFormatting.RESET);
            InfoUtils.printActionbarMessage((String)"tweakermore.impl.autoFillContainer.container_filled", (Object[])new Object[]{containerScreen.getTitle(), stackName, percentage});
            return ProcessResult.terminated();
        }
        InfoUtils.printActionbarMessage((String)"tweakermore.impl.autoFillContainer.best_slot_not_found", (Object[])new Object[0]);
        return ProcessResult.skipped();
    }
}

