/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.TweakerMoreConfigBooleanHotkeyed;
import me.fallenbreath.tweakermore.config.options.listentries.AutoCollectMaterialListItemLogType;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.IContainerProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ProcessResult;
import me.fallenbreath.tweakermore.mixins.tweaks.features.autoCollectMaterialListItem.MaterialListHudRendererAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerMaterialListItemCollector
implements IContainerProcessor {
    @Override
    public TweakerMoreConfigBooleanHotkeyed getConfig() {
        return TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM;
    }

    private static void log(Message.MessageType type, String translationKey, Object ... args) {
        if (TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_MESSAGE_TYPE.getOptionListValue() == AutoCollectMaterialListItemLogType.FULL) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)type, (String)translationKey, (Object[])args);
        } else {
            String text = type.getFormatting() + StringUtils.translate((String)translationKey, (Object[])args) + GuiBase.TXT_RST;
            InfoUtils.printActionbarMessage((String)text, (Object[])new Object[0]);
        }
    }

    @Override
    public ProcessResult process(LocalPlayer player, AbstractContainerScreen<?> containerScreen, List<Slot> allSlots, List<Slot> playerInvSlots, List<Slot> containerInvSlots) {
        MaterialListBase materialList = DataManager.getMaterialList();
        if (materialList != null) {
            MaterialListHudRendererAccessor hudRendererAccessor = (MaterialListHudRendererAccessor)materialList.getHudRenderer();
            String guiTitle = containerScreen.getTitle().getString();
            MaterialListUtils.updateAvailableCounts((List)materialList.getMaterialsAll(), (Player)player);
            List missingOnly = materialList.getMaterialsMissingOnly(true);
            boolean summaryOnly = TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_MESSAGE_TYPE.getOptionListValue() == AutoCollectMaterialListItemLogType.SUMMARY;
            ArrayList summaries = Lists.newArrayList();
            boolean takenSomething = false;
            for (MaterialListEntry entry : missingOnly) {
                int missing = entry.getCountMissing() * materialList.getMultiplier() - entry.getCountAvailable();
                ItemStack stack = entry.getStack();
                if (missing <= 0) continue;
                int totalTaken = 0;
                for (Slot slot : containerInvSlots) {
                    if (!InventoryUtils.areStacksEqual((ItemStack)stack, (ItemStack)slot.getItem())) continue;
                    int stackAmount = slot.getItem().getCount();
                    this.moveToPlayerInventory(containerScreen, playerInvSlots, slot, Math.min(missing, stackAmount));
                    int moved = stackAmount - slot.getItem().getCount();
                    totalTaken += moved;
                    TweakerMoreMod.LOGGER.debug("Moved {}x {} to player inventory, still miss {} items", (Object)moved, (Object)stack.getItem().getName().getString(), (Object)(missing -= moved));
                    if (moved != 0) continue;
                    TweakerMoreMod.LOGGER.debug("Player inventory is full for item {}", (Object)stack.getItem().getName().getString());
                    break;
                }
                if (totalTaken <= 0) continue;
                if (!takenSomething && !summaryOnly) {
                    ContainerMaterialListItemCollector.log(Message.MessageType.INFO, "tweakermore.impl.autoCollectMaterialListItem.info.title", guiTitle);
                }
                takenSomething = true;
                String missingColor = missing == 0 ? GuiBase.TXT_GREEN : GuiBase.TXT_GOLD;
                ChatFormatting formatting = stack.getRarity().color();
                String stackName = String.valueOf(formatting) + stack.getItemName().getString() + GuiBase.TXT_RST;
                if (summaryOnly) {
                    summaries.add(String.format("%s +%s", stackName, missingColor + totalTaken + GuiBase.TXT_RST));
                    continue;
                }
                ContainerMaterialListItemCollector.log(Message.MessageType.INFO, "tweakermore.impl.autoCollectMaterialListItem.info.line", GuiBase.TXT_GOLD + totalTaken + GuiBase.TXT_RST, stackName, missingColor + hudRendererAccessor.invokeGetFormattedCountString(missing, stack.getMaxStackSize()) + GuiBase.TXT_RST);
            }
            if (takenSomething) {
                if (summaryOnly) {
                    ContainerMaterialListItemCollector.log(Message.MessageType.INFO, Joiner.on((String)", ").join((Iterable)summaries), new Object[0]);
                }
            } else {
                ContainerMaterialListItemCollector.log(Message.MessageType.INFO, "tweakermore.impl.autoCollectMaterialListItem.took_nothing", guiTitle);
            }
            hudRendererAccessor.setLastUpdateTime(-1L);
        } else {
            ContainerMaterialListItemCollector.log(Message.MessageType.WARNING, "tweakermore.impl.autoCollectMaterialListItem.no_material_list", new Object[0]);
        }
        return new ProcessResult(true, TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_CLOSE_GUI.getBooleanValue());
    }

    private void moveToPlayerInventory(AbstractContainerScreen<?> containerScreen, List<Slot> playerInvSlots, Slot fromSlot, int amount) {
        ItemStack stack = fromSlot.getItem().copy();
        if (amount == stack.getCount()) {
            InventoryUtils.shiftClickSlot(containerScreen, (int)fromSlot.index);
            return;
        }
        if (amount > stack.getCount()) {
            TweakerMoreMod.LOGGER.warn("Too many items to move to player inventory, the stack {} has {} items but {} items are required", (Object)stack.getItem(), (Object)stack.getCount(), (Object)amount);
            return;
        }
        InventoryUtils.leftClickSlot(containerScreen, (int)fromSlot.index);
        for (int idx = playerInvSlots.size() - 1; idx >= 0; --idx) {
            Slot slot = playerInvSlots.get(idx);
            int clickAmount = 0;
            if (slot.hasItem() && InventoryUtils.areStacksEqual((ItemStack)slot.getItem(), (ItemStack)stack)) {
                ItemStack invStack = slot.getItem();
                clickAmount = Math.min(invStack.getMaxStackSize() - invStack.getCount(), amount);
            } else if (!slot.hasItem()) {
                clickAmount = amount;
            }
            for (int i = 0; i < clickAmount; ++i) {
                InventoryUtils.rightClickSlot(containerScreen, (int)slot.index);
            }
            if ((amount -= clickAmount) == 0) break;
        }
        InventoryUtils.leftClickSlot(containerScreen, (int)fromSlot.index);
        if (amount != 0) {
            TweakerMoreMod.LOGGER.warn("Failed to move full item stack to player inventory, {} items remains", (Object)amount);
        }
    }
}

