/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.growthSpeed.handlers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.impl.features.infoView.growthSpeed.handlers.GrowthSpeedRendererHandler;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

abstract class BasicGrowthSpeedRendererHandler
implements GrowthSpeedRendererHandler {
    BasicGrowthSpeedRendererHandler() {
    }

    protected static Component tr(String key, Object ... args) {
        return Messenger.tr("tweakermore.impl.infoViewGrowthSpeed." + key, args);
    }

    protected static String round(double value, int maxDigit) {
        if (maxDigit == 0) {
            return String.valueOf(Math.round(value));
        }
        double base = Math.pow(10.0, maxDigit);
        return String.valueOf((double)Math.round(value * base) / base);
    }

    protected static MutableComponent bool(boolean value) {
        return BasicGrowthSpeedRendererHandler.bool(value, value ? ChatFormatting.GREEN : ChatFormatting.RED);
    }

    protected static MutableComponent bool(boolean value, ChatFormatting colorOverride) {
        return Messenger.s(value ? "\u221a" : "x", colorOverride);
    }

    protected static ChatFormatting heatColor(double value) {
        if (value >= 0.8) {
            return ChatFormatting.GREEN;
        }
        if (value >= 0.5) {
            return ChatFormatting.YELLOW;
        }
        if (value >= 0.2) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.RED;
    }

    protected static MutableComponent pair(Component key, Component value) {
        return Messenger.c(key, Messenger.s(": ", ChatFormatting.GRAY), value);
    }

    protected static class Attribute {
        public final Component name;
        public final Component value;
        public final boolean hideIfSingleLine;

        private Attribute(Component name, Component value, boolean hideIfSingleLine) {
            this.name = name;
            this.value = value;
            this.hideIfSingleLine = hideIfSingleLine;
        }
    }

    protected static class Attributes {
        private final List<Attribute> attributes = Lists.newArrayList();

        protected Attributes() {
        }

        public void add(Object name, Object value, boolean hideIfSingleLine) {
            this.attributes.add(new Attribute((Component)Messenger.tf(name), (Component)Messenger.tf(value), hideIfSingleLine));
        }

        public void add(Object name, Object value) {
            this.add(name, value, false);
        }

        public MutableComponent toSingleLine() {
            return Messenger.join(Messenger.s(" "), (Component[])this.attributes.stream().filter(a -> !a.hideIfSingleLine).map(a -> a.value).toArray(Component[]::new));
        }

        public List<MutableComponent> toMultiLines() {
            return this.attributes.stream().map(a -> BasicGrowthSpeedRendererHandler.pair(a.name, a.value)).collect(Collectors.toList());
        }

        public void export(List<MutableComponent> lines, boolean isCrossHairPos) {
            if (isCrossHairPos) {
                lines.addAll(this.toMultiLines());
            } else {
                lines.add(this.toSingleLine());
            }
        }
    }
}

