/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.growthSpeed.handlers;

import java.util.List;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.growthSpeed.handlers.BasicGrowthSpeedRendererHandler;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockState;

public class SmallMushroomGrowthSpeedRenderer
extends BasicGrowthSpeedRendererHandler {
    @Override
    public boolean isTarget(BlockState blockState) {
        return blockState.getBlock() instanceof MushroomBlock;
    }

    @Override
    public void addInfoLines(RenderVisitorWorldView world, BlockPos pos, boolean isCrossHairPos, List<MutableComponent> lines) {
        boolean canGrow;
        int count = SmallMushroomGrowthSpeedRenderer.countSameBlocks(world, pos);
        boolean bl = canGrow = SmallMushroomGrowthSpeedRenderer.countSameBlocks(world, pos) < 5;
        if (isCrossHairPos) {
            lines.add(SmallMushroomGrowthSpeedRenderer.pair(SmallMushroomGrowthSpeedRenderer.tr("mushroom.count", new Object[0]), (Component)Messenger.s(count, ChatFormatting.GOLD)));
            lines.add(SmallMushroomGrowthSpeedRenderer.pair(SmallMushroomGrowthSpeedRenderer.tr("mushroom.can_grow", new Object[0]), (Component)SmallMushroomGrowthSpeedRenderer.bool(canGrow)));
        } else {
            lines.add(SmallMushroomGrowthSpeedRenderer.bool(canGrow));
        }
    }

    private static int countSameBlocks(RenderVisitorWorldView world, BlockPos pos) {
        Block mushroomBlock = world.getBlockState(pos).getBlock();
        int count = 0;
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (world.getBlockState(blockPos).getBlock() != mushroomBlock) continue;
            ++count;
        }
        return count;
    }
}

